<#ftl attributes={"description":"Brief reason for sending jabber notification to user (plain text)"}>
<#escape x as x?html>
    <p>
        <#if reason.message?has_content>
            <@l10n>Vous avez reçu ce message parce que ${reason.message}.</@l10n>
        <#else>
            <#if only_via_duplicate>
                <#assign subreasons  = reason.subreasons>
                <#assign subreason  = subreasons?first>
                <#if (subreasons?size > 1)>
                    <@l10n>Vous avez reçu ce message parce que vous avez activé les notifications pour « ${subreason.name} » (${subreason.issueId}), etc.</@l10n>
                <#else>
                    <@l10n>Vous avez reçu ce message parce que vous avez activé les notifications pour « ${subreason.name} » (${subreason.issueId}).</@l10n>
                </#if>
            <#else>
                <#assign mentionsCount = reason.mentionReasons?size>
                <#assign savedSearchesCount = reason.savedSearchReasons?size>
                <#assign subreasonsCount = mentionsCount + savedSearchesCount + reason.tagReasons?size>

                <#if (mentionsCount > 0)>
                    <#if (subreasonsCount > 1)>
                        <@l10n>Vous avez reçu ce message parce que vous avez activé les notifications pour @Mention, etc.</@l10n>
                    <#else>
                        <@l10n>Vous avez reçu ce message parce que vous avez activé les notifications pour @Mention.</@l10n>
                    </#if>
                <#elseif (savedSearchesCount > 0)>
                    <#assign subreason = reason.savedSearchReasons?first>
                    <#if (subreasonsCount > 1)>
                        <@l10n>Vous avez reçu ce message parce que vous avez activé les notifications pour la recherche enregistrée « ${subreason.name} », etc.</@l10n>
                    <#else>
                        <@l10n>Vous avez reçu ce message parce que vous avez activé les notifications pour la recherche enregistrée « ${subreason.name} ».</@l10n>
                    </#if>
                <#else>
                    <#assign subreason = reason.tagReasons?first>
                    <#if (subreasonsCount > 1)>
                        <@l10n>Vous avez reçu ce message parce que vous avez activé les notifications pour la balise « ${subreason.name} », etc.</@l10n>
                    <#else>
                        <@l10n>Vous avez reçu ce message parce que vous avez activé les notifications pour la balise « ${subreason.name} ».</@l10n>
                    </#if>
                </#if>
            </#if>
        </#if>
    </p>
</#escape>