<#ftl attributes={"description":"Overview of the issue update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign priority = issue.Priority>
    <#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
    <#if change.hasEvent("CREATED")>
        <#if (!priority?is_enumerable && priority == "Show-stopper")>
            <@l10n>新しい致命的な課題が${issue.reporter.getVisibleName()}さんによって報告されました：</@l10n>
        <#else>
            <@l10n>新しい課題が${issue.reporter.getVisibleName()}さんによって報告されました：</@l10n>
        </#if>
    <#elseif last_notification?has_content && last_notification>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("PROJECT")>
            <#if from == to>
                <@l10n>
                        ${time}にあなたは1件の課題を課題を読み込む権限のないプロジェクトに移動しました。
                </@l10n>
            <#else>
                <@l10n>
                    ${time}に、${from.getVisibleName()}さんが1件の課題をあなたが課題を読み込む権限のないプロジェクトに移動しました。
                </@l10n>
            </#if>
        <#elseif change.hasEvent("PERMITTED")>
            <#if from == to>
                <@l10n>
                        ${time}に、あなたは1件の課題の表示をあなたが所属していないユーザーグループに対して制限しました。
                </@l10n>
            <#else>
                <@l10n>
                    ${time}に、${from.getVisibleName()}さんが1件の課題の表示をあなたが所属していないユーザーグループに対して制限しました。
                </@l10n>
            </#if>
        <#elseif change.hasEvent("DELETED")>
            <#if from == to>
                <@l10n>
                        ${time}に、あなたは${issue.project.name} プロジェクトの課題を1件削除しました。
                </@l10n>
            <#else>
                <@l10n>
                        ${time}に、${from.getVisibleName()}さんが${issue.project.name} プロジェクトの課題を1件削除しました。
                </@l10n>
            </#if>
        <#else>
            <@l10n>
                    ${time}に、${from.getVisibleName()}さんが1件の課題へのアクセスを制限しました。
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <#if isShowStopper>
                <@l10n>あなたが致命的な課題を変更しました：</@l10n>
            <#else>
                <@l10n>あなたが課題を変更しました：</@l10n>
            </#if>
        <#else>
            <#if isShowStopper>
                <@l10n>ユーザーの${from.getVisibleName()}さんが致命的な課題を変更しました：</@l10n>
            <#else>
                <@l10n>ユーザーの${from.getVisibleName()}さんが課題を変更しました：</@l10n>
            </#if>
        </#if>
    </#if>
</p>
</#escape>