<#ftl attributes={"description":"Presentation of an issue with all significant properties: id, description, summary, values of fields etc."}>
<#escape x as x?html>
    <#if Utils.hasVisibilityRestrictions(issue)>
        <div style="margin-top: .5em;">
            <span style="color: #777777;">
                ${Utils.getVisibilityPresentation(issue)}
            </span>
        </div>
    </#if>
    <#include "tags_panel.ftl">
    <#include "links_panel.ftl">
    <#include "attachments_panel.ftl">
    <hr style="height: 1px;
               max-height: 1px;
               border: 0;
               background: #d9d9d9;
               margin: 19px 0 15px;"/>
    <#include "fields_panel.ftl">
    <#include "sprints_panel.ftl">
    <#if issue.comments?has_content>
        <div>
            <hr style="height: 1px;
                         max-height: 1px;
                         border: 0;
                         background: #d9d9d9;
                         margin: 19px 0 15px;"/>
            <#assign count = issue.comments?size>
            <#if count == 1>
                <@l10n>1 comentário</@l10n>
            <#else>
                <@l10n>${count} comentários</@l10n>
            </#if>
        </div>
    </#if>
</#escape>