<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>

    <#if reason.message?has_content>
        <@l10n>Você (<b>${to.login}</b>) recebeu esta mensagem porque ${reason.message}.</@l10n>
    <#else>
        <#assign tagsCount = reason.tagReasons?size>
        <#assign savedSearchesCount = reason.savedSearchReasons?size>
        <#assign mentionsCount = reason.mentionReasons?size>
        <#assign onlyMention = (savedSearchesCount == 0) && (tagsCount == 0)>

        <#if onlyMention>
            <#if only_via_duplicate>
                <@l10n>
                    Você (<b>${to.login}</b>) recebeu esta mensagem porque você tinha habilitado a opção
                    <b>Receber notificações sobre alterações em um grupo de issues duplicadas</b> e você foi <b>mencionado</b>.
                
                </@l10n>
            <#else>
                <@l10n>
                    Você (<b>${to.login}</b>) recebeu esta mensagem porque você foi <b>mencionado</b>.
                </@l10n>
            </#if>
        <#else>
            <#if only_via_duplicate>
                <@l10n>
                    Você (<b>${to.login}</b>) recebeu esta mensagem porque você tinha habilitado a opção
                    <b>Receber notificações sobre alterações em um grupo de issues duplicadas</b> e notificações para:
                </@l10n>
            <#else>
                <@l10n>
                    Você (<b>${to.login}</b>) recebeu esta mensagem porque você tinha habilitado as notificações para:
                </@l10n>
            </#if>

            <@l10n>
            <#list reason.savedSearchReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (savedSearchesCount > 1)>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            pesquisas savlas;
                        <#else>
                            pesquisas savlas.
                        </#if>
                    <#else>
                        <#if (tagsCount > 0 || mentionsCount > 0)>
                            pesquisas savlas;
                        <#else>
                            pesquisas savlas.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <@l10n>
            <#list reason.tagReasons as subreason>
                <#if subreason_has_next>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                <#else>
                    <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    <#if (tagsCount > 1)>
                        <#if (mentionsCount > 0)>
                            etiquetas;
                        <#else>
                            etiquetas.
                        </#if>
                    <#else>
                        <#if (mentionsCount > 0)>
                            etiquetas;
                        <#else>
                            etiquetas.
                        </#if>
                    </#if>
                </#if>
            </#list>
            </@l10n>

            <#if (mentionsCount > 0) >
                <@l10n><b>@menção</b> em um comentário ou uma descrição da uma issue.</@l10n>
            </#if>
        </#if>
    </#if>
    <#if last_notification?has_content && last_notification>
        <@l10n>
            Para receber menos mensagens como esta,
            <a href="${Utils.getSettingUrl(to)}">edite suas preferências de notificação</a>.
        </@l10n>
    <#else>
        <@l10n>
            Para cancelar a inscrição, você pode
            <a href="${Utils.getSettingUrlWithMute(to,issue)}">silenciar as notificações para essa issue</a> ou
            <a href="${Utils.getSettingUrl(to)}">edite suas preferências de notificação</a>.
        </@l10n>
    </#if>
</#escape>