<#escape x as x?html>
<html>
    <#include "markup_styles.ftl">
    <p style="font-size: 14px;
              color: #000000;
              margin: 0.5em 0 0.4em 0;">
        <#if only_via_duplicate><@l10n>Uma duplicata de issue(s) que você está assistinda foi alterada.</@l10n></#if>
        <#assign priority = issue.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000">
        <#else>
            <#assign issueTypeStyle = "">
        </#if>
        <#assign type = issue.Type>
        <#if from == to>
            <#if type?has_content>
                <@l10n>
                    <em style="${issueTypeStyle}">${type}</em> foi atribuída
                    para si mesmo no projeto <em>${issue.project.name}</em>
                </@l10n>
            <#else>
                <@l10n>
                    <em style="${issueTypeStyle}">Issue</em> foi atribuída
                    para si mesmo no projeto <em>${issue.project.name}</em>
                </@l10n>
            </#if>
        <#else>
            <#if type?has_content>
                <@l10n>
                    <em style="${issueTypeStyle}">${type}</em> foi atribuído a <em>você</em>
                    por ${from.getVisibleName()} no projeto <em>${issue.project.name}</em>
                </@l10n>
            <#else>
                <@l10n>
                        <em style="${issueTypeStyle}">Issue</em> foi atribuída a <em>você</em>
                         por ${from.getVisibleName()} no projeto <em>${issue.project.name}</em>
                </@l10n>
            </#if>
        </#if>
    </p>
    <div style="background-color: #efefef">
        <#include "issue_header.ftl">
    </div>
    <#if change.before?has_content>
        <#include "issue_change.ftl">
    <#else>
        <#include "issue.ftl">
    </#if>
    <#include "footer.ftl">
</html>
</#escape>