<#escape x as x?html>
<html>
    <#include "markup_styles.ftl">
    <#assign after = change.after>
    <#assign before = change.before>
    <p style="font-size: 14px;
              color: #000000;
              margin: 0.5em 0 0.4em 0;">
        <#if only_via_duplicate><@l10n>Uma duplicata de issue(s) que você está assistinda foi alterada.</@l10n></#if>
        <#assign priority = change.after.Priority>
        <#if (!priority?is_enumerable && (priority == "Critical" || priority == "Show-stopper"))>
            <#assign issueTypeStyle = "color: #cc0000">
        <#else>
            <#assign issueTypeStyle = "">
        </#if>
        <#assign type = after.Type>
        <#if from==to>
            <#if type?has_content>
                <@l10n>
                    <em style="${issueTypeStyle}">${type}</em> foi atualizada por <em>você</em>
                    no projeto <em>${after.project.name}</em> em ${change.getWhen(to)}.
                </@l10n>
            <#else>
                <@l10n>
                    <em style="${issueTypeStyle}">Issue</em> foi atualizada por <em>você</em>
                    no projecto <em>${after.project.name}</em> em ${change.getWhen(to)}.
                </@l10n>
            </#if>
        <#else>
            <#if type?has_content>
                <@l10n>
                    <em style="${issueTypeStyle}">${type}</em> foi atualizada por <em>${from.getVisibleName()}</em>
                    no projeto <em>${after.project.name}</em> em ${change.getWhen(to)}.
                </@l10n>
            <#else>
                <@l10n>
                    <em style="${issueTypeStyle}">Issue</em> foi atualizada por <em>${from.getVisibleName()}</em>
                    no projeto <em>${after.project.name}</em> em ${change.getWhen(to)}.
                </@l10n>
            </#if>
        </#if>
        <#if after.isResolved() && before?has_content && !before.isResolved()>
            <#assign duplicate = Utils.getDuplicate(after)>
            <#if duplicate?has_content>
                <@l10n>Issue foi resolvida como duplicata de <a href="${Utils.getUrl(duplicate)}">${duplicate.getId()}</a>.</@l10n>
           <#else>
                <#assign state = after.State>
                <#if state?has_content && !(state?is_enumerable)>
                    <@l10n>Issue foi resolvida como: ${state}.</@l10n>
                <#else>
                    <@l10n>Issue foi resolvida.</@l10n>
                </#if>
            </#if>
        </#if>
    </p>
    <div style="background-color: #efefef">
        <#include "issue_header.ftl">
    </div>
    <#include "issue_change.ftl">
    <#include "footer.ftl">
</html>
</#escape>