<#if only_via_duplicate><p><@l10n>Uma duplicata de issue(s) que você está assistinda foi alterada</@l10n></p></#if>
<#assign after = change.after>
<#assign before = change.before>
<#assign priority = after.Priority>
<#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
<#if from == to>
    <#if isShowStopper>
        <p><@l10n>Você mudou uma issue show-stopper:</@l10n></p>
    <#else>
        <p><@l10n>Você mudou a issue:</@l10n></p>
    </#if>
<#else>
    <#if isShowStopper>
        <p><@l10n>Usuário $ {from.getVisibleName ()} mudou uma issue show-stopper:</@l10n></p>
    <#else>
        <p><@l10n>Usuário $ {from.getVisibleName ()} mudou a issue:</@l10n></p>
    </#if>
</#if>
<p>${after.getId()} ${after.summary}</p>
<p>${Utils.getUrl(after)}</p>
<#if after.isResolved() && before?has_content && !before.isResolved()>
    <#assign duplicate = Utils.getDuplicate(after)>
    <#if duplicate?has_content>
        <p><@l10n>Issue foi resolvida como duplicata de ${duplicate.getId()}</@l10n></p>
        <p>${duplicate.getUrl()}</p>
    <#else>
        <#assign state = after.State>
        <#if state?has_content && !(state?is_enumerable)>
            <p><@l10n>Issue foi resolvida como: ${state}</@l10n></p>
        <#else>
            <p><@l10n>Issue foi resolvida</@l10n></p>
        </#if>
    </#if>
</#if>
<p>--------------------</p>

<#--project change-->
<#if before.project != after.project>
    <p><@l10n>Projecto: ${before.project.name} -> ${after.project.name}</@l10n></p>
</#if>

<#--permitted group change-->
<#if !Utils.hasSameVisibility(before, after)>
    <p><@l10n>Visível para o grupo: ${Utils.getVisibilityPresentation(before)} -> ${Utils.getVisibilityPresentation(after)}</@l10n></p>
</#if>

<#--summary change-->
<#if before.summary != after.summary>
    <p><@l10n>Resumo alterado</@l10n></p>
</#if>

<#--description change-->
<#if before.description != after.description>
    <p><@l10n>Descrição alterada</@l10n></p>
</#if>

<#--attachments change-->
<#list change.getRemovedAttachments() as removed>
    <p><@l10n>-Anexo <a href="${Utils.getAttachmentUrl(removed)}">${removed.name}</a></@l10n></p>
</#list>
<#list change.getAddedAttachments() as added>
    <p><@l10n>+Anexo <a href="${Utils.getAttachmentUrl(added)}">${added.name}</a></@l10n></p>
</#list>

<#--links change-->
<#list change.getRemovedLinks() as removedLink>
    <#assign oppositeIssue = removedLink.to>
    <#assign linkName = removedLink.capitalizedRole>
    <p>-${linkName} <a href="${Utils.getUrl(oppositeIssue)}">${oppositeIssue.getId()}: ${oppositeIssue.summary}</a></p>
</#list>
<#list change.getAddedLinks() as addedLink>
    <#assign oppositeIssue = addedLink.to>
    <#assign linkName = addedLink.capitalizedRole>
    <p>+${linkName} <a href="${Utils.getUrl(oppositeIssue)}">${oppositeIssue.getId()}: ${oppositeIssue.summary}</a></p>
</#list>

<#--custom fields change-->
<#list change.getCustomFieldChanges() as fieldChange>
    <#assign fieldName = fieldChange.field.name>
    <p>${fieldName}: ${fieldChange.prevPresentation} -> ${fieldChange.nextPresentation}</p>
</#list>

<p>--------------------</p>
<#include "reason_jabber.ftl">
