<#escape x as x?html>
<html>
    <#import "styles.ftl" as styles>
    <table style="${styles.table} margin: 16px 0;">
        <tr>
            <td style="width: ${styles.icon_width}px;
                       padding: 0;
                       vertical-align: top;">
                <div style="padding: 2px 0 0 14px;">
                        <#include "icon_warning.ftl">
                </div>
            </td>
            <td style="padding: 0; vertical-align: top;">
                <div style="${styles.overview_text}">
                    <@l10n>
                        Em ${vcsChange.humanReadableDate}, YouTrack processou uma alteração do VCS por <b>${vcsChange.userName}</b>. 
                        A mensagem de submissão contém um comando que faz referência a uma issue no projeto ${issue.project.name}.
                        Infelizmente, o comando não é válido. A issue referenciada não foi atualizada.
                    </@l10n>
                    <br/>
                    <br/>
                    <#list vcsChange.commandExecutionInfos as error>
                        <#if error.errorText?has_content>
                            <#noescape>${error.errorText}</#noescape><br/>
                        </#if>
                    </#list>
                    <br/>
                    <br/>
                    <@l10n>
                        Para atualizar a issue, clique no link desta mensagem para abrir a issue no YouTrack e aplicar as alterações 
                        desejadas manualmente.
                    </@l10n>
                </div>
            </td>
        </tr>
    </table>

    <#include "issue_header.ftl">

    <div style="margin-top: 16px">
        <table style="${styles.table} background: #f0f0f0;">
            <tr>
                <td style="${styles.event_title};">
                    <img src="${Utils.getAvatarUrl(vcsChange.user)}"
                         alt="${vcsChange.user.getVisibleName()}"
                         width="24"
                         height="24"/>
                </td>

                <td style="padding: 12px 0;">
                    ${vcsChange.text}
                </td>
                <td style="padding: 12px 16px;">
                    <a title="${issue.project.name}"
                       style="color: #1466c6; float: right;"
                       href="${vcsChange.changeUrl}">
                        ${vcsChange.version}
                    </a>
                </td>
            </tr>
        </table>
    </div>
    <div style="margin-left: ${styles.icon_width}px; padding: 4px 0 8px;">
        <#include "vcs_failure_footer.ftl">
    </div>
</html>
</#escape>