<#ftl attributes={"description":"List of added and removed attachments"}>
<#escape x as x?html>
    <#assign attachments = Utils.getVisibleAttachments(issue)>
    <#if attachments?has_content>
    <ul style="margin: 1em 0 0 0 !important;
               padding: 0 !important">
        <#list attachments as attachment>
            <li style="display: inline-block;
                       font-size: 13px;
                       list-style: none;
                       padding: 0 !important;
                       margin: 0 !important;">
                <a href="${Utils.getAttachmentUrl(attachment)}"
                   title="<#if Utils.hasVisibilityRestrictions(attachment)>
                                <@l10n>Добавлено пользователем ${attachment.author.getVisibleName()} для ${Utils.getVisibilityPresentation(attachment)}</@l10n>
                          <#else>
                                <@l10n>Добавлено пользователем ${attachment.author.getVisibleName()}</@l10n>
                          </#if>">
                    <span style="color: #105CB6;
                                 text-decoration: none;">
                        ${attachment.name}
                    </span>
                </a>
                <span style="color: #9EA1A5; font-size:11px;">
                    <#if attachment.size?has_content>
                        <#assign size = attachment.size>
                        <#if (size < 1024)>
                            (<@l10n>${size}&nbsp;байт</@l10n>)
                        <#else>
                            <#if (1024 <= size && size < 1024*1024) >
                                (<@l10n>${size/1024}&nbsp;КБ</@l10n>)
                            <#else>
                                (<@l10n>${size/(1024*1024)}&nbsp;МБ</@l10n>)
                            </#if>
                        </#if>
                    <#else>
                        (<@l10n>0&nbsp;Б</@l10n>)
                    </#if>
                </span>
            </li>
        </#list>
    </ul>
    </#if>
    <#assign invisibleCount = Utils.getInvisibleAttachmentsCount(issue)>
    <#if (invisibleCount > 0)>
        <div>
            <#if (invisibleCount == 1)>
                <@l10n>У вас нет разрешений на просмотр еще одного вложения к этой задаче</@l10n>
            <#else >
                <@l10n>У вас нет разрешений на просмотр еще ${invisibleCount} вложений к этой задаче</@l10n>
            </#if>
        </div>
    </#if>
</#escape>