<#ftl attributes={"description":"Overview of the issue update in jabber notification"}>
<#escape x as x?html>
<p>
    <#assign priority = issue.Priority>
    <#assign isShowStopper = (!priority?is_enumerable && priority == "Show-stopper")>
    <#if change.hasEvent("CREATED")>
        <#if (!priority?is_enumerable && priority == "Show-stopper")>
            <@l10n>Новая неотложная задача была создана пользователем ${issue.reporter.getVisibleName()}:</@l10n>
        <#else>
            <@l10n>Новая задача была создана пользователем ${issue.reporter.getVisibleName()}:</@l10n>
        </#if>
    <#elseif last_notification?has_content && last_notification>
        <#assign time = change.getWhen()>
        <#if change.hasEvent("PROJECT")>
            <#if from == to>
                <@l10n>
                    ${time} вы переместили задачу в проект, в котором у вас нет разрешения на чтение задач.
                </@l10n>
            <#else>
                <@l10n>
${time} пользователь ${from.getVisibleName()} переместил задачу в проект, в котором у вас нет разрешения на чтение задач.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("PERMITTED")>
            <#if from == to>
                <@l10n>
                    On ${time}, you restricted the visibility of an issue to a group of users that you don't belong to.
                </@l10n>
            <#else>
                <@l10n>
${time} пользователь ${from.getVisibleName()} сделал задачу видимой только для группы пользователей, к которой вы не принадлежите.
                </@l10n>
            </#if>
        <#elseif change.hasEvent("DELETED")>
            <#if from == to>
                <@l10n>
                        ${time} вы удалили задачу в проекте ${issue.project.name}.
                </@l10n>
            <#else>
                <@l10n>
                        ${time} пользователь ${from.getVisibleName()} удалил задачу в проекте ${issue.project.name}.
                </@l10n>
            </#if>
        <#else>
            <@l10n>
                    ${time} пользователь ${from.getVisibleName()} ограничил доступ к задаче.
            </@l10n>
        </#if>
    <#else>
        <#if from == to>
            <#if isShowStopper>
                <@l10n>Вы изменили неотложную задачу:</@l10n>
            <#else>
                <@l10n>Вы изменили задачу:</@l10n>
            </#if>
        <#else>
            <#if isShowStopper>
                <@l10n>Пользователь ${from.getVisibleName()} изменил неотложную задачу:</@l10n>
            <#else>
                <@l10n>Пользователь ${from.getVisibleName()} изменил задачу:</@l10n>
            </#if>
        </#if>
    </#if>
</p>
</#escape>