<#ftl attributes={"description":"Detailed reason for sending email notification to user (HTML)"}>
<#escape x as x?html>

    <#if reason.message?has_content>
        <@l10n>Вы (<b>${to.login}</b>) получили это сообщение по следующей причине: ${reason.message}.</@l10n>
    <#else>
        <#assign tagsCount = reason.tagReasons?size>
        <#assign savedSearchesCount = reason.savedSearchReasons?size>
        <#assign mentionsCount = reason.mentionReasons?size>
        <#assign onlyMention = (savedSearchesCount == 0) && (tagsCount == 0)>

        <#if onlyMention>
            <#if only_via_duplicate>
                <@l10n>
                    Вы (<b>${to.login}</b>) получили это сообщение, потому что включили параметр 
                    <b>Получать уведомления об изменениях в кластере-дубликате</b> и были <b>упомянуты</b>.
                </@l10n>
            <#else>
                <@l10n>
                    Вы (<b>${to.login}</b>) получили это сообщение, потому что были <b>упомянуты</b>.
                </@l10n>
            </#if>
        <#else>
            <#if only_via_duplicate>
                <@l10n>
                    Вы (<b>${to.login}</b>) получили это сообщение, потому что включили параметр 
                    <b>Получать уведомления об изменениях в кластере-дубликате</b> и уведомления для:
                </@l10n>
            <#else>
                <@l10n>
                    Вы (<b>${to.login}</b>) получили это сообщение, потому что включили уведомления для:
                </@l10n>
            </#if>

            <@l10n>            <#list reason.savedSearchReasons as subreason>
                 <#if subreason_index==0>
                    <#if (savedSearchesCount > 1)>
                       сохраненных поисков <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                    <#else>
                       сохраненного поиска <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    </#if>
                <#elseif subreason_has_next>
                  <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
				<#else>
                  <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                </#if>
                <#if !subreason_has_next>
                  <#if (tagsCount > 0 || mentionsCount > 0)>;<#else>.</#if>
                </#if>
            </#list></@l10n>

            <@l10n>              <#list reason.tagReasons as subreason>
                <#if subreason_index==0>
                    <#if (tagsCount > 1)>
                       тегов <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
                    <#else>
                       тега <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                    </#if>
                <#elseif subreason_has_next>
                  <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>,
				<#else>
                  <b>${subreason.name}<#if only_via_duplicate> (${subreason.issueId})</#if></b>
                </#if>
                <#if !subreason_has_next>
                  <#if (mentionsCount > 0)>;<#else>.</#if>
                </#if>
            </#list>
</@l10n>

            <#if (mentionsCount > 0) >
                <@l10n><b>@Упоминание</b> в комментарии или описании задачи.</@l10n>
            </#if>
        </#if>
    </#if>
    <#if last_notification?has_content && last_notification>
        <@l10n>
            Чтобы получать меньше подобных сообщений,
            <a href="${Utils.getSettingUrl(to)}">измените настройку уведомлений.</a>
        </@l10n>
    <#else>
        <@l10n>
Чтобы отменить подписку, вы можете
    <a href="${Utils.getSettingUrlWithMute(to,issue)}">игнорировать уведомления по этой задаче</a> или
    <a href="${Utils.getSettingUrl(to)}">изменить настройку уведомлений.</a>        </@l10n>
    </#if>
</#escape>