cr.setTemplateBind("IntegerEditor", function (path) {
  cr.ach(path, "intValue", "keydown", function (event, data) {
    return event.handleEnterEsc(function () {
      if (cr.findInHandler(event, "" + "." + "intValue", []).value.length) {
        var value = parseInt(cr.findInHandler(event, "" + "." + "intValue", []).value);
        if (isNaN(value) || value > 2097152 * 1024 - 1 || value < -2097152 * 1024 + 1) {
          cr.findInHandler(event, "" + "." + "intValue", []).highlight(l10n('${l10n("IntegerEditor.Integer_value_expected")}'));
        } else {
          cr.findInHandler(event, "" + "." + "intValue", []).value = value;
          cr.findInHandler(event, "" + "." + "integerContentInlineEditor", []).submit();
        }

      } else {
        cr.serverMethodCallInHandler(event, "" + "." + "methodCall_setUndefinedValue", {});
      }

    }, function () {
      cr.findInHandler(event, "" + "." + "integerContentInlineEditor", []).abort();
    });
  });
  cr.ach(path, "clearValue", "click", function (event, data) {
    //Prevent bubbling
    return false;
  });
  cr.ach(path, "integerContentInlineEditor", "createeditor", function (event, data) {
    $(cr.findInHandler(event, "" + "." + "intField", [])).addClass("cf-edit");
    $(cr.findInHandler(event, "" + "." + "intField", [])).parent().addClass("cf-visible");
  });
  cr.ach(path, "integerContentInlineEditor", "abort", function (event, data) {
    $(cr.findInHandler(event, "" + "." + "intField", [])).removeClass("cf-edit");
    $(cr.findInHandler(event, "" + "." + "intField", [])).parent().removeClass("cf-visible");
  });
  cr.ach(path, "integerContentInlineEditor", "submit", function (event, data) {
    $(cr.findInHandler(event, "" + "." + "intField", [])).removeClass("cf-edit");
    $(cr.findInHandler(event, "" + "." + "intField", [])).parent().removeClass("cf-visible");
  });
  cr.ash(path, "clearValue", "click", null);
  cr.ash(path, "integerContentInlineEditor", "createeditor", {preventDoubleSubmit: true});
  cr.ash(path, "integerContentInlineEditor", "submit", {preventDoubleSubmit: true});
  regic(path, "integerContentInlineEditor");
});
