Webr.ErrorMessage = function (message, severity, inputName, propertyName) {
  this.message = message;
  this.inputName = inputName;
  this.severity = severity;
  this.propertyName = propertyName;
};
Webr.ErrorMessage.prototype.createHighlighter = function () {
  this.errorHighlighter = Webr.ErrorHighlighter.highlightError(this.inputName, this.message);
};
Webr.ErrorMessage.prototype.clear = function () {
  if (this.errorHighlighter) {
    this.errorHighlighter.destroy();
  }

};
Webr.ErrorMessage.ERROR = "error";
Webr.ErrorMessage.INFO = "info";
Webr.ErrorMessage.errorMessages = [];
Webr.ErrorMessage.addMessage = function (message, severity, inputName, propertyName) {
  var newErrorMessage = new Webr.ErrorMessage(message, severity, inputName, propertyName);
  Webr.ErrorMessage.errorMessages.push(newErrorMessage);
  if (inputName) {
    newErrorMessage.createHighlighter();
  } else {
    Webr.ErrorMessage.showErrorAlert();
  }

};
Webr.ErrorMessage.clearErrorMessages = function () {
  var msgs = Webr.ErrorMessage.errorMessages;
  for (var i = 0; i < msgs.length; i += 1) {
    msgs[i].clear();
  }

  Webr.ErrorMessage.errorMessages = [];
};
Webr.ErrorMessage.closePopup = function () {
  if (Webr.ErrorMessage.POPUP) {
    Webr.ErrorMessage.POPUP.hide();
  }

  Webr.event.PopupMessage.ERROR.hide();
};
Webr.ErrorMessage.createErrorMessageHtml = function () {
  var messageHtml = "";
  for (var i = 0; i < Webr.ErrorMessage.errorMessages.length; i += 1) {
    var propertyName = "";
    if (Webr.ErrorMessage.errorMessages[i].propertyName) {
      propertyName = ": <b>" + Webr.ErrorMessage.errorMessages[i].propertyName + "</b>";
    }

    messageHtml += "<li class=\"" + Webr.ErrorMessage.errorMessages[i].severity + "\">" + Webr.ErrorMessage.errorMessages[i].message + propertyName + "</li>";
  }

  return messageHtml;
};
Webr.ErrorMessage.showErrorAlert = function () {
  var messageHtml = Webr.ErrorMessage.createErrorMessageHtml();
  if (!Webr.ErrorMessage.POPUP) {
    Webr.ErrorMessage.POPUP = new Webr.event.PopupMessage({styleClass: "error", closable: true, onClose: Webr.ErrorMessage.clearErrorMessages});
  }

  Webr.ErrorMessage.POPUP.show(messageHtml);
};
Webr.ErrorHighlighter = function (element, message) {
  if (element.tagName.toLowerCase() === "input") {
    this.input = element;
    this.elementType = this.input.type.toLowerCase();
    this.label = cr.findById(this.input.id + "Label");
  } else if (element.tagName.toLowerCase() === "select") {
    this.select = element;
    this.elementType = "select";
  }

  this.message = message;
  var self = this;
  this.dismissHandler = function () {
    self.destroy();
  };
};
Webr.ErrorHighlighter.prototype.create = function () {
  var el;
  if (this.elementType !== "select") {
    if (this.elementType === "checkbox") {
      $(this.label).addClass(Webr.ErrorHighlighter.LABEL_ERROR_STYLE_CLASS);
    } else {
      $(this.input).addClass(Webr.ErrorHighlighter.INPUT_ERROR_STYLE_CLASS).focus();
    }

    this.registerInputEvents();
    el = this.input;
  } else {
    $(this.select).addClass(Webr.ErrorHighlighter.LABEL_ERROR_STYLE_CLASS);
    this.registerSelectEvents();
    el = this.select;
  }

  this.tooltip = new Webr.component.ErrorTooltip(el, this.message);
};
Webr.ErrorHighlighter.prototype.destroy = function () {
  if (this.elementType !== "select") {
    if (this.elementType === "checkbox") {
      $(this.label).removeClass(Webr.ErrorHighlighter.LABEL_ERROR_STYLE_CLASS);
    } else {
      $(this.input).removeClass(Webr.ErrorHighlighter.INPUT_ERROR_STYLE_CLASS).focus();
    }

    this.unregisterInputEvents();
  } else {
    $(this.select).removeClass(Webr.ErrorHighlighter.LABEL_ERROR_STYLE_CLASS);
    this.unregisterSelectEvents();
  }

  Webr.component.ErrorTooltip.destroy(this.tooltip);
};
Webr.ErrorHighlighter.prototype.registerInputEvents = function () {
  $(this.input).one("keydown click", this.dismissHandler);
};
Webr.ErrorHighlighter.prototype.registerSelectEvents = function () {
  $(this.select).one("change click blur", this.dismissHandler);
};
Webr.ErrorHighlighter.prototype.unregisterInputEvents = function () {
  var eventTarget = $(this.input);
  if (this.elementType != "file") {
    eventTarget.unbind("keydown", this.dismissHandler);
  } else {
    eventTarget.unbind("click", this.dismissHandler);
  }

};
Webr.ErrorHighlighter.prototype.unregisterSelectEvents = function () {
  $(this.select).unbind("change click blur", this.dismissHandler);
};
Webr.ErrorHighlighter.INPUT_ERROR_STYLE_CLASS = "form-has-error";
Webr.ErrorHighlighter.TOOLTIP_ANCHOR_STYLE_CLASS = "error-bulb2";
Webr.ErrorHighlighter.LABEL_ERROR_STYLE_CLASS = "has-error";
Webr.ErrorHighlighter.highlightError = function (elementName, message) {
  if (elementName) {
    return Webr.ErrorHighlighter.highlightErrorInput($("input[name='" + elementName + "']").get(0), message);
  }

  return null;
};
Webr.ErrorHighlighter.highlightErrorInput = function (input, message) {
  if (input) {
    var highlighter = input.createHighlighter(message);
    highlighter.create();
    return highlighter;
  }

  return null;
};
Webr.ErrorHighlighter.highlightErrorElement = function (element, message) {
  if (element) {
    var tag = element.tagName.toLowerCase();
    var highlighter;
    if (tag === "input") {
      highlighter = element.createHighlighter(message);
      highlighter.create();
    } else if (tag === "select") {
      highlighter = element.createHighlighter(message);
    }

    return highlighter;
  }

};
Webr.component.ErrorTooltip = function (target, message) {
  this.createAnchor(target);
  this.createMessageContainer(message);
  this._show();
};
Webr.component.ErrorTooltip.prototype.createAnchor = function (target) {
  this.tooltipAnchor = this.createDivElement(Webr.component.ErrorTooltip.ANCHOR_STYLE_CLASS);
  var targetInsideDialog = $(target).closest("." + "jt-dialog");
  var root = targetInsideDialog.get(0) ?targetInsideDialog :$(document.body);
  root.append(this.tooltipAnchor);
  this.setAnchorPosition(target, targetInsideDialog.get(0));
};
Webr.component.ErrorTooltip.prototype.setAnchorPosition = function (target, dialog) {
  var targetPos = dialog ?this.getPositionInsideDialog(dialog, target) :$(target).offset();
  var isCombobox = $(target).closest("div." + "combobox");
  var dX = isCombobox.get(0) ?isCombobox.outerWidth() :$(target).outerWidth();
  var dY = ($(target).outerHeight(true) - $(this.tooltipAnchor).height()) / 2;
  $(this.tooltipAnchor).css({top: targetPos.top + dY, left: targetPos.left + dX});
};
Webr.component.ErrorTooltip.prototype.getPositionInsideDialog = function (dialog, element) {
  var dp = $(dialog).offset();
  var ep = $(element).offset();
  return {top: ep.top - dp.top, left: ep.left - dp.left};
};
Webr.component.ErrorTooltip.prototype.createMessageContainer = function (message) {
  this.tooltipContainer = this.createDivElement("error-tooltip");
  $(this.tooltipContainer).text(message);
  this.tooltip = new Webr.component.ToolTip($(this.tooltipAnchor), this.tooltipContainer, false, false);
};
Webr.component.ErrorTooltip.prototype.createDivElement = function (cssClass) {
  var div = document.createElement("div");
  if (cssClass) {
    $(div).addClass(cssClass);
  }

  return div;
};
Webr.component.ErrorTooltip.prototype._show = function () {
  $(this.tooltipAnchor).show();
};
Webr.component.ErrorTooltip.ANCHOR_STYLE_CLASS = "error-bulb2";
Webr.component.ErrorTooltip.destroy = function (errorTooltip) {
  Webr.component.ToolTip.destroy(errorTooltip.tooltip);
  $(errorTooltip.tooltipAnchor).remove();
  $(errorTooltip.tooltipContainer).remove();
  delete errorTooltip;
};
