Webr.event.ResponseServerEventListener = function (syncCall) {
  Webr.event.ResponseServerEventListener.superclass.constructor.call(this);
  this.syncCall = syncCall;
  if (syncCall) {
    Webr.event.ResponseServerEventListener.SYNC_CALL_IN_PROGRESS = true;
  }

};
{
  var F = new Function();
  F.prototype = Webr.event.ServerEventListener.prototype;
  Webr.event.ResponseServerEventListener.prototype = new F();
  Webr.event.ResponseServerEventListener.prototype.constructor = Webr.event.ResponseServerEventListener;
  Webr.event.ResponseServerEventListener.superclass = Webr.event.ServerEventListener.prototype;
}

Webr.event.ResponseServerEventListener.prototype.onSuccess = function (event, response) {
  if (response.responseXML && response.responseXML.firstChild) {
    Webr.event.ResponseServerEventListener.connected();
    Webr.event.ResponseServerEventListener.processXmlResponse(response.responseXML);
  } else {
    Webr.event.ResponseServerEventListener.error("Incorrect response structure");
  }

  if (this.syncCall) {
    Webr.event.ResponseServerEventListener.SYNC_CALL_IN_PROGRESS = false;
  }

};
Webr.event.ResponseServerEventListener.prototype.onFinish = function (event, success, exception) {
  if (!success) {
    if (exception != null) {
      if (exception.isTimeout() || exception.isCommunication()) {
        Webr.event.ResponseServerEventListener.disconnected();
      } else {
        Webr.event.ResponseServerEventListener.error(exception.statusText);
      }

    }

    if (this.syncCall) {
      Webr.event.ResponseServerEventListener.SYNC_CALL_IN_PROGRESS = false;
    }

  }

};
Webr.event.ResponseServerEventListener.SYNC_CALL_IN_PROGRESS = false;
Webr.event.ResponseServerEventListener.DISCONNECTED = false;
Webr.event.ResponseServerEventListener.DISCONNECTED_POPUP = Webr.event.PopupMessage.SMALL_ERROR;
Webr.event.ResponseServerEventListener.PAGE_CHANGED = false;
Webr.event.ResponseServerEventListener.connected = function () {
  if (Webr.event.ResponseServerEventListener.DISCONNECTED && !Webr.event.ResponseServerEventListener.RELOAD_INTERVAL) {
    Webr.event.ResponseServerEventListener.DISCONNECTED = false;
    Webr.event.ResponseServerEventListener.DISCONNECTED_POPUP.hide();
  }

};
Webr.event.ResponseServerEventListener.disconnected = function () {
  if (!Webr.event.ResponseServerEventListener.DISCONNECTED && !Webr.event.ResponseServerEventListener.PAGE_CHANGED) {
    //Just in case HeartBeat was failed while reload ticker
    Webr.event.ResponseServerEventListener.abortReload();
    Webr.event.ResponseServerEventListener.disconnectedMessage(l10n('${l10n("ResponseServerEventListener.js.Connection_Lost")}'));
    Webr.event.InProgressEventListener.get().eventsInProgress = [];
    Webr.event.ResponseServerEventListener.DISCONNECTED = true;
  }

};
Webr.event.ResponseServerEventListener.reloadDelayed = function (seconds) {
  if (!Webr.event.ResponseServerEventListener.RELOAD_INTERVAL) {
    Webr.event.ResponseServerEventListener.TIME_TO_RELOAD = seconds;
    Webr.event.ResponseServerEventListener.RELOAD_INTERVAL = window.setInterval(Webr.event.ResponseServerEventListener.waitReloadTick, 1000);
  }

};
Webr.event.ResponseServerEventListener.waitReloadTick = function () {
  if (Webr.event.ResponseServerEventListener.TIME_TO_RELOAD > 0) {
    Webr.event.ResponseServerEventListener.disconnectedMessage(l10n('${l10n("ResponseServerEventListener.js.Connection_Restored_{Reload}_{time_to_reload}")}', '<a href="javascript:reload();">' + l10n('${l10n("ResponseServerEventListener.js.Reload")}') + '</a>', Webr.event.ResponseServerEventListener.TIME_TO_RELOAD));
    --Webr.event.ResponseServerEventListener.TIME_TO_RELOAD;
  } else {
    Webr.event.ResponseServerEventListener.abortReload();
    Webr.Event.reloadInternal(function () {
      //On success - just reload
      Webr.Event.reload();
    }, function (jqXHR, textStatus, errorThrown) {
      Webr.event.ResponseServerEventListener.internalReloadError(textStatus, errorThrown);
    });
  }

};
Webr.event.ResponseServerEventListener.callInternalReload = function () {
  Webr.event.ResponseServerEventListener.abortReload();
  Webr.event.ResponseServerEventListener.disconnectedMessage(l10n('${l10n("ResponseServerEventListener.js.Reloading")}'));
  Webr.Event.reloadInternal(function (data) {
    var headEnd = "</head>";
    var start = data.indexOf("<head");
    var head = data.substring(start, data.indexOf(headEnd, start) + headEnd.length);
    var bodyEnd = "</body>";
    start = data.indexOf("<body");
    var body = data.substring(start, data.indexOf(bodyEnd, start) + bodyEnd.length);
    //process scripts from head and css links
    trace("Stop all active timers and intervals!");
    Webr.TimerUtil.clearAll();
    trace("Replacing head...");
    Webr.event.ResponseServerEventListener.processHead(head, function () {
      //replace body
      trace("Replacing body...");
      time("Set body");
      Webr.event.RefreshCommandProcessor.setContentToElement(document.body, body);
      timeEnd("Set body");
      Webr.event.ResponseServerEventListener.abortReload();
    });
  }, function (jqXHR, textStatus, errorThrown) {
    Webr.event.ResponseServerEventListener.abortReload();
    Webr.event.ResponseServerEventListener.internalReloadError(textStatus, errorThrown);
  });
};
Webr.event.ResponseServerEventListener.internalReloadError = function (textStatus, errorThrown) {
  //On internal reload error show meessage
  Webr.event.ResponseServerEventListener.disconnected();
  Webr.event.ResponseServerEventListener.disconnectedMessage(errorThrown && errorThrown.length > 0 ?l10n('${l10n("ResponseServerEventListener.js.Connection_{status}_{error}")}', textStatus, errorThrown) :l10n('${l10n("ResponseServerEventListener.js.Connection_{status}")}', textStatus));
};
Webr.event.ResponseServerEventListener.abortReload = function () {
  if (Webr.event.ResponseServerEventListener.RELOAD_INTERVAL) {
    window.clearInterval(Webr.event.ResponseServerEventListener.RELOAD_INTERVAL);
    Webr.event.ResponseServerEventListener.RELOAD_INTERVAL = null;
  }

};
Webr.event.ResponseServerEventListener.processHead = function (head, onFinish) {
  //execute scripts that are not src
  trace("Loading CSSes...");
  Webr.event.RefreshCommandProcessor.loadCSS(head, function () {
    trace("Unbind everything from document!");
    $(document).unbind();
    trace("Loading JSes...");
    Webr.event.RefreshCommandProcessor.executeScripts(head, onFinish);
  });
};
Webr.event.ResponseServerEventListener.disconnectedMessage = function (message) {
  Webr.event.ResponseServerEventListener.DISCONNECTED_POPUP.show(message);
};
Webr.event.ResponseServerEventListener.error = function (message) {
  //Ignore
};
Webr.event.ResponseServerEventListener.processXmlResponse = function (xml) {
  time("processXmlResponse");
  var nodes;
  if ("commands" == xml.firstChild.nodeName) {
    nodes = xml.firstChild.childNodes;
  } else {
    if ("command" == xml.firstChild.nodeName) {
      nodes = xml.childNodes;
    } else {
      Webr.event.PopupMessage.SYSTEM.show("Unexpected response: " + xml.firstChild.nodeName, 10000);
      return ;
    }

  }

  var prcs = Webr.event.CommandProcessor.commandProcessors;
  var context = new Webr.event.ProcessingContext();
  context.queue();
  for (var j = 0; j < nodes.length; j += 1) {
    var command = nodes.item(j);
    if (command.nodeType != 1) {
            continue;

    }

    for (var i = 0; i < prcs.length; i += 1) {
      try {
        if (prcs[i].processCommand(command, context)) {
                    break;

        }

      } catch (e) {
        throw e;
      }

    }

  }

  context.release();
  timeEnd("processXmlResponse");
};


var reload = Webr.Event.reload;
