charisma.smartui.IssueDescriptionSupport = function (description) {
  this.root = description;
  this.win = $(window);
  this.description = this.root.children().first();
  this.descriptionTopOffset = this.description.offset().top;
  if (this._registerHandlers()) {
    this._countDescriptionHeight();
  }

};
charisma.smartui.IssueDescriptionSupport.prototype._registerHandlers = function () {
  //listen to wiki collapse
  var _this = this;
  this.description.click(function (event) {
    if ($(event.target).hasClass("wiki-plus")) {
      _this._countDescriptionHeight();
    }

    return true;
  });
    

  var allImagesLoaded = true;
  this.description.find("img").each(function () {
    var complete = this.complete;
    if (!complete) {
      this.onload = function () {
        _this._change();
      };
      allImagesLoaded = false;
    }

  });
    

  //listen to window changes
  var proxy = jQuery.proxy(this._change, this);
  this.win.scroll(proxy).resize(proxy);
  return allImagesLoaded;
};
charisma.smartui.IssueDescriptionSupport.prototype._change = function () {
  var _this = this;
  this._startMove();
  window.clearTimeout(this.changeTimer);
  this.changeTimer = window.setTimeout(function () {
    _this._countDescriptionHeight();
  }, 100);
};
charisma.smartui.IssueDescriptionSupport.prototype._countDescriptionHeight = function () {
  //temporary drop setted height to count real height
  this._setHeight(-1);
    

  this.descriptionHeight = this.description.height();
  this.root.height(this.descriptionHeight);
    

  this._fixHeight();
};
charisma.smartui.IssueDescriptionSupport.prototype._startMove = function () {
  window.clearTimeout(this.showTimer);
  this._setHeight(-1);
};
charisma.smartui.IssueDescriptionSupport.prototype._stopMove = function () {
  var _this = this;
  this.showTimer = window.setTimeout(function () {
    //fix height little bit later to prevent scroller blinking
    _this._fixHeight();
  }, 400);
};
charisma.smartui.IssueDescriptionSupport.prototype._fixHeight = function () {
  var descriptionVisibleHeight = this._getDescriptionVisibleHeight();
  var height = -1;
    

  //win height+scroll < descr height+scroll
  if (this.descriptionHeight - descriptionVisibleHeight > 0) {
    height = Math.round(descriptionVisibleHeight);
  }

    

  this._setHeight(height);
};
charisma.smartui.IssueDescriptionSupport.prototype._setHeight = function (height) {
  var height = height < 0 ?"" :height + "px";
  var el = this.description.get(0);
  el.style.height = height;
};
charisma.smartui.IssueDescriptionSupport.prototype._getDescriptionVisibleHeight = function () {
  return (this.win.height() + this.win.scrollTop()) - this.descriptionTopOffset;
};
