charisma.smartui.IssueId = function () {
};
charisma.smartui.IssueId.MASK = 63;
charisma.smartui.IssueId.CC_0 = "0".charCodeAt(0);
charisma.smartui.IssueId.CC_BA = "A".charCodeAt(0);
charisma.smartui.IssueId.CC_SA = "a".charCodeAt(0);
charisma.smartui.IssueId.SORT = function (a, b) {
  return a - b;
};
charisma.smartui.IssueId.encodeIssueIds = function (ids) {
  var len = ids.length;
    

  //prepare ids
  for (var i = 0; i < len; i += 1) {
    ids[i] = charisma.smartui.IssueId.cutIssueType(ids[i]);
  }

  //sort
  ids.sort(charisma.smartui.IssueId.SORT);
  //delta
  for (var i = len - 1; i > 0; i -= 1) {
    ids[i] -= ids[i - 1];
  }

  var res = charisma.smartui.IssueId.toString(ids[0]);
  for (var i = 1; i < len; i += 1) {
    res += "-" + charisma.smartui.IssueId.toString(ids[i]);
  }

  return res;
};
charisma.smartui.IssueId.cutIssueType = function (issueId) {
  var sep = issueId.indexOf("-");
  var issueLocalId = sep > 0 ?issueId.substring(sep + 1, issueId.length) :issueId;
  return parseInt(issueLocalId);
};
charisma.smartui.IssueId.toString = function (n) {
  var res = "";
  var mask = charisma.smartui.IssueId.MASK;
  do{
    res = charisma.smartui.IssueId.toChar(n & mask) + res;
    n >>= 6;
  } while (n > 0);

  return res;
};
charisma.smartui.IssueId.toChar = function (n) {
  var c;
  if (n < 10) {
    c = charisma.smartui.IssueId.CC_0 + n;
  } else if (n < 36) {
    c = charisma.smartui.IssueId.CC_BA + n - 10;
  } else {
    c = charisma.smartui.IssueId.CC_SA + n - 36;
  }

  return String.fromCharCode(c);
};
