charisma.smartui.IssueSupport = function () {
  charisma.smartui.IssueSupport.superclass.constructor.call(this);
    

  commonController = this;
  this.initKeyHandlers();
};
{
  var F = new Function();
  F.prototype = charisma.smartui.CommonController.prototype;
  charisma.smartui.IssueSupport.prototype = new F();
  charisma.smartui.IssueSupport.prototype.constructor = charisma.smartui.IssueSupport;
  charisma.smartui.IssueSupport.superclass = charisma.smartui.CommonController.prototype;
}

charisma.smartui.IssueSupport.prototype.init = function (config) {
  this.updateConfig(config);
  this.registerTextCopierEvents();
  Webr.Event.internalReloadUrl = config.internalReloadUrl;
};
charisma.smartui.IssueSupport.prototype.isRingHeaderVisible = function () {
  return $('[data-test="header"]').is(":visible");
};
charisma.smartui.IssueSupport.prototype.setCommandsToolbar = function (container) {
  var self = this;
  var setCommandToolbar = function () {
    self.commandsToolbar = new charisma.smartui.Toolbar(container);
    self.initToolbarListener();
    //check whether page is scrolled down
    self.commandsToolbar.scroll();
  };
    

  var timer = window.setInterval(function () {
    if (self.isRingHeaderVisible()) {
      window.clearInterval(timer);
      setCommandToolbar();
    }

  }, 150);
};
charisma.smartui.IssueSupport.prototype.initToolbarListener = function () {
  var it = this;
  var context = '.topToolbar';
  var handleClose = function () {
    var combo = $(".issuePermission__combo").eq(1);
    if (combo) {
      var cn = combo.attr("_cn_");
      if (cn) {
        var cbc = cr.findById(cn);
        if (cbc && cbc.renderer) {
          cbc.renderer.reset();
        }

      }

    }

  };
  $(window).off(context).on('scroll' + context, function () {
    if (it.getToolbar().shown) {
      handleClose();
    }

  });
  this.getToolbar().container.off(context).on(charisma.smartui.Toolbar.EVENT_SHOW + context + ' ' + charisma.smartui.Toolbar.EVENT_HIDE + context, function () {
    window.setTimeout(function () {
      handleClose();
    }, 50);
  });
};
charisma.smartui.IssueSupport.prototype.updateConfig = function (config) {
  this.config = this.config || {};
  var it = this;
  jQuery.each(config, function (key, value) {
    it.config[key] = value;
  });
};
charisma.smartui.IssueSupport.prototype.setDescriptionScrollHandler = function (issueDescription) {
  if (issueDescription.length > 0) {
    new charisma.smartui.IssueDescriptionSupport(issueDescription);
  }

};
charisma.smartui.IssueSupport.prototype.setSummaryToolbar = function (config) {
  var self = this;
  var toolbar;
    

  var initToolbar = function () {
    var toolbar = self.getToolbar();
    var topMarin = toolbar.originalDimensions && toolbar.originalDimensions[1];
        

    var summaryToolbar = new charisma.smartui.SummaryToolbar(self.config.summaryToolbarContainer, topMarin, self.commandsToolbar);
    ToolbarGuard.get(summaryToolbar);
    summaryToolbar.scroll();
  };
    

  var timer = window.setInterval(function () {
    if (self.getToolbar() && $(self.config.summaryToolbarContainer).is(":visible") && self.isRingHeaderVisible()) {
      window.clearInterval(timer);
      initToolbar();
      self.setDescriptionScrollHandler(config.issueDescription);
    }

  }, 150);
    

};
charisma.smartui.IssueSupport.prototype.update = function (config) {
  var firstCall = (this.config == undefined);
    

  this.updateConfig(config);
  if (!firstCall) {
    this.registerTextCopierEvents();
  }

    

  this.setSummaryToolbar(config);
};
charisma.smartui.IssueSupport.prototype.initKeyHandlers = function () {
  var it = this;
  $(document).keydown(function (event) {
    if (Webr.component.panel.Dialog.isModalVisible() || charisma.smartui.ViewImageAttachment.isVisible()) {
      return true;
    }

        

    //global keys
    if (!event.targetIsInput() && Webr.util.Key.isApplicable(event, SmartUIShortCuts["ToggleSearchField"]) && (!it.issuesList || !it.issuesList.focused)) {
      it.searchField.focus();
      return false;
    }

        

    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["EditIssue"])) {
      if (!it.commentsList.isFocused()) {
        charisma.smartui.TextCopier.hideCopier(true);
        it.config.editButton.click();
        return false;
      }

    }

    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["SwitchToCommentsTab"])) {
      it.config.issueTabs.activateTab(0);
      return false;
    }

    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["SwitchToHistoryTab"])) {
      it.config.issueTabs.activateTab(1);
      return false;
    }

    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["SwitchToLinksTab"])) {
      it.config.issueTabs.activateTab(2);
      return false;
    }

    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["PrevIssue"]) && it.config.goPrevIssueButton) {
      Webr.Event.redirect(it.config.goPrevIssueButton.href);
      return false;
    }

    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["NextIssue"]) && it.config.goNextIssueButton) {
      Webr.Event.redirect(it.config.goNextIssueButton.href);
      return false;
    }

    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["GoBack"])) {
      it.config.goBackButton.click();
      return false;
    }

    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["StarIssue"])) {
      it.config.star.click();
      return false;
    }

    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["SelectIssueIdSummary"])) {
      if (!it.editMode) {
        charisma.smartui.TextSelector.selectText(it.config.issueIdContainer.get(0), it.config.issueSummary.get(0));
      }

    }

    if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["SelectIssueId"]) && !event.targetIsInput()) {
      var selection = Webr.util.Util.getSelection();
      if (!(selection && selection != "")) {
        charisma.smartui.TextSelector.setSelection(it.config.issueIdContainer.get(0));
        return false;
      }

    }

    if (!event.targetIsInput()) {
      if (Webr.util.Key.isApplicable(event, SmartUIShortCuts["DeleteIssue"]) || (Webr.util.Util.isMac && (Webr.util.Key.isApplicable(event, SmartUIShortCuts["DeleteIssue_Backspace"])))) {
        event.preventDefault();
        event.stopPropagation();
        commandDialog && commandDialog.show(commonController.deleteCommand);
        return false;
      }

    }

    return true;
  });
};
charisma.smartui.IssueSupport.prototype.onAddComment = function () {
  $(this.commentsList.newCommentTexArea).focus();
};
charisma.smartui.IssueSupport.prototype.getSelectedIssuesIds = function () {
  var issueIds = [this.getFocusedIssueId()];
    

  return issueIds;
};
charisma.smartui.IssueSupport.prototype.registerTextCopierEvents = function () {
  var cfg = this.config;
  if (!cfg.issueIdContainer) {
    return ;
  }

  cfg.issueIdContainer.parent().parent().mouseenter(function () {
    charisma.smartui.TextCopier.showCopier(cfg.issueIdContainer, cfg.issueSummary, cfg.issueId);
  }).mouseleave(function () {
    charisma.smartui.TextCopier.hideCopier();
  });
  cfg.issueDescription.mouseenter(function () {
    charisma.smartui.TextCopier.showCopier(cfg.issueDescription, null, cfg.issueId);
  }).mouseleave(function () {
    charisma.smartui.TextCopier.hideCopier();
  });
  info("TextCopier register handler");
};
charisma.smartui.IssueSupport.prototype.togglerExceptionsView = function () {
  var issueDescription = $("pre." + "wiki-exception-title").prev();
    

  if (issueDescription.get(0) && issueDescription.click()) {
    this.exceptionStateToggler();
  }

};
charisma.smartui.IssueSupport.prototype.setCommentsList = function (list) {
  if (this.commentsList) {
    this.commentsList.unhandleKeys();
    this.commentsList = null;
    delete this.commentsList;
  }

  this.commentsList = list;
  this.commentsList.setToolbar(this.commandsToolbar);
};
charisma.smartui.IssueSupport.prototype.getFocusedIssueId = function () {
  return this.newIssueId ?this.newIssueId :this.config.issueId;
};
charisma.smartui.IssueSupport.prototype.getFocusedPresentationIssueId = function () {
  return this.newIssueId ?'${l10n("CommonController.draft")}' :this.config.issueIdPresentation;
};
charisma.smartui.IssueSupport.prototype.commentsLoaded = function (commentsList) {
  this.setCommentsList(commentsList);
};
charisma.smartui.IssueSupport.prototype.commentsRefreshed = function (edit) {
  var selectedComment = this.commentsList.getSelected();
  selectedComment.refresh(edit);
};
charisma.smartui.IssueSupport.prototype.finishIssueEdit = function () {
  this.config.setEditMode(false, false);
};
charisma.smartui.IssueSupport.prototype.toggleEditMode = function (edit) {
  charisma.smartui.IssueSupport.superclass.toggleEditMode.call(this, edit);
  $(".fsi__tabs")[edit ?'hide' :'show']();
  this.editMode = edit;
  charisma.smartui.TextSelector.clearTextSelection();
  if (!edit) {
    document.title = this.config.issueSummary.text() + " : " + this.config.issueSummary.prev().text();
  }

};
charisma.smartui.IssueSupport.prototype.updateLinkedIssueList = function (content, subtaskTypeName) {
  this.updateIssueList({content: content, focusOnLoad: true, sortData: {subtaskTypeName: subtaskTypeName}});
};
charisma.smartui.IssueSupport.prototype.updateIssueList = function (config) {
  var list = this.issuesList;
  if (!list) {
    list = new charisma.smartui.LinkedIssueList(config);
    this.setComponent("issuesList", list);
    list.select();
  } else {
    list.init(config);
  }

};
charisma.smartui.IssueSupport.prototype.issueRedrawn = function (issueId, focus) {
  this.issuesList && this.issuesList.issueRedrawn(issueId, focus);
};
charisma.smartui.IssueSupport.prototype.focusIssue = function () {
  $("." + "issueIdAnchor").focus();
  return true;
};
charisma.smartui.IssueSupport.prototype.getToolbar = function () {
  return this.commandsToolbar;
};
charisma.smartui.IssueSupport.prototype.getCommentList = function () {
  return this.commentsList;
};
charisma.smartui.IssueSupport.prototype.initDragUpload = function (handler, windowId) {
  charisma.smartui.IssueSupport.superclass.initDragUpload.call(this, handler, windowId);
};
charisma.smartui.LinkedIssueList = function (config) {
  charisma.smartui.LinkedIssueList.superclass.constructor.call(this, config);
};
{
  var F = new Function();
  F.prototype = charisma.smartui.IssueList.prototype;
  charisma.smartui.LinkedIssueList.prototype = new F();
  charisma.smartui.LinkedIssueList.prototype.constructor = charisma.smartui.LinkedIssueList;
  charisma.smartui.LinkedIssueList.superclass = charisma.smartui.IssueList.prototype;
}

charisma.smartui.LinkedIssueList.prototype.getNextPrevIssue = function (next, focused) {
  var issue;
  if (next) {
    issue = focused.next().next("." + "issueContainer");
  } else {
    issue = focused.prev().prev("." + "issueContainer");
  }

  return issue;
};
charisma.smartui.FullScreenIssueConfig = function () {
};


var fsi;
