charisma.Rest = function () {
};
charisma.Rest.get = function (restMethod, params, onSuccess, eventName) {
  var url = charisma.Rest.url(restMethod);
  if (params) {
    var paramsStr;
    var first = true;
    var addValueToQuery = function (name, value) {
      if (value != undefined && value != null && (typeof value != "string" || value != "")) {
        if (first) {
          paramsStr = "?";
          first = false;
        } else {
          paramsStr += "&";
        }

        paramsStr += encodeURIComponent(name) + "=" + encodeURIComponent(value);
      }

    };
    for ( var name in params) {
      var value = params[name];
      if (jQuery.isArray(value)) {
        jQuery.each(value, function (index, item) {
          addValueToQuery(name, item);
        });
      } else {
        addValueToQuery(name, value);
      }

    }

    if (paramsStr) {
      url += paramsStr;
    }

  }

  Webr.Event.get({eventName: eventName, headers: {Accept: "application/json"}, handlerUrl: url, hideLoadingPopup: true, collectFileElements: false, collectFormElements: false, pollInterval: 10, processRecentOnly: true, listeners: [new charisma.RestRequestListener(onSuccess)]});
};
charisma.Rest.post = function (restMethod, body, onSuccess, onFailure) {
  Webr.Event.post({headers: {Accept: "application/json", "Content-Type": "application/json"}, handlerUrl: charisma.Rest.url(restMethod), sync: false, preventDoubleSubmit: false, processRecentOnly: false, collectFormElements: true, body: body, listeners: onSuccess ?[new charisma.RestRequestListener(onSuccess, onFailure)] :null});
};
charisma.Rest.url = function (restMethod) {
  var url = Webr.Event.rootUrl + "rest/" + restMethod;
  return url;
};
charisma.RestRequestListener = function (onSuccessCallback, onFailureCallback) {
  charisma.RestRequestListener.superclass.constructor.call(this);
  this.onSuccessCallback = onSuccessCallback;
  this.onFailureCallback = onFailureCallback;
};
{
  var F = new Function();
  F.prototype = Webr.event.ServerEventListener.prototype;
  charisma.RestRequestListener.prototype = new F();
  charisma.RestRequestListener.prototype.constructor = charisma.RestRequestListener;
  charisma.RestRequestListener.superclass = Webr.event.ServerEventListener.prototype;
}

charisma.RestRequestListener.prototype.onSuccess = function (event, response) {
  var json = jQuery.parseJSON(response.responseText);
  this.onSuccessCallback(json);
};
charisma.RestRequestListener.prototype.onFailure = function (event, response) {
  if (this.onFailureCallback) {
    this.onFailureCallback(response);
  }

};
charisma.RestRequestListener.prototype.onException = function (event, exception) {
  if (this.onFailureCallback) {
    this.onFailureCallback(exception);
  }

};
