charisma.smartui.SidebarToggler = function (toggler, content, sidebar) {
  this.toggler = toggler ?"#" + toggler.id.replaceAll("\\.", "\\.") :null;
  this.content = content ?"#" + content.id.replaceAll("\\.", "\\.") :null;
  this.sidebar = sidebar ?"#" + sidebar.id.replaceAll("\\.", "\\.") :null;
};
charisma.smartui.SidebarToggler.prototype.setVisible = function (visible) {
  if (this.sidebar) {
    var sidebar = $(this.sidebar);
    if (visible) {
      sidebar.show();
    } else {
      sidebar.hide();
    }

    $(this.content).toggleClass("noSidebar");
    $(this.toggler).children().toggleClass("sidebar_collapsed");
  }

};
charisma.smartui.SidebarToggler.prototype.updatePositionAndHeight = function (wrapper) {
  if (Webr.util.Util.isIE && Webr.util.Util.browserVersion <= 7) {
    var toggler = $(this.toggler);
    toggler.hide();
    var pos = wrapper.offset();
    toggler.css({"left": pos.left - 22, "top": pos.top, "height": wrapper.height()});
    toggler.fadeIn("slow");
  }

};
charisma.smartui.SidebarToggler.prototype.click = function () {
  $(this.toggler).click();
};
