charisma.smartui.Toolbar = function (container, toolbarCopy, noShadow, verticalMargin) {
  this.shown = false;
  this.doc = $(document);
  this.win = $(window);
  this.toolbarCopy = false;
  this.position = {};
  this.current_state = null;
  this.container = $(container);
  this.parent = this.container.parent();
  this.toolbarCopy = toolbarCopy;
  this.toolbarCopy || this.setHeightToParentElement();
  this.verticalMargin = verticalMargin || 0;
  this.bindEvents();
  this.saveParentOffset();
  this.createShadow(noShadow);
  this.current_state = charisma.smartui.Toolbar.state_PINNED;
};
charisma.smartui.Toolbar.prototype.isFarScroll = function () {
  return (this.position.top - 12 - this.verticalMargin / 6) < (this.doc.scrollTop() + this.verticalMargin);
};
charisma.smartui.Toolbar.prototype.setHeightToParentElement = function () {
  //to prevent vertical trembling of the issue list container (affects combobox positioning)
  if (this.parent.get(0)) {
    this.parent.css({"min-height": this.container.outerHeight()});
  }

};
charisma.smartui.Toolbar.prototype.saveParentOffset = function () {
  if (this.parent.get(0)) {
    var pos = this.parent.offset();
    this.position = {top: pos.top, left: pos.left};
    this.saveOriginalDimentions();
    this.currentDimensions = [0, 0];
  }

};
charisma.smartui.Toolbar.prototype.saveOriginalDimentions = function () {
  this.originalDimensions = [this.parent.width(), this.container.height()];
};
charisma.smartui.Toolbar.prototype.createShadow = function (noShadow) {
  if (noShadow) {
    this.shadow = Webr.component.Shadow.EMPTY_SHADOW;
  } else {
    this.shadow = Webr.component.Shadow.getShadow(this.container);
  }

};
charisma.smartui.Toolbar.prototype.updateMenuPosition = function () {
  if (Webr.component.Menu.OPEN_MENU != null) {
    Webr.component.Menu.OPEN_MENU.setItemsPosition();
  }

};
charisma.smartui.Toolbar.prototype._show = function () {
  this.shown = true;
  this.visualizeToolbarContent(true);
  this._update();
  this.shadow.show();
  this.updateMenuPosition();
  this.triggerShowEvent();
};
charisma.smartui.Toolbar.prototype.triggerShowEvent = function () {
  this.container.trigger(charisma.smartui.Toolbar.EVENT_SHOW);
};
charisma.smartui.Toolbar.prototype._hide = function () {
  this.shown = false;
  this.shadow.hide();
  this.visualizeToolbarContent(false);
  this._update(true);
  this.updateMenuPosition();
  this.container.trigger(charisma.smartui.Toolbar.EVENT_HIDE);
};
charisma.smartui.Toolbar.prototype.visualizeToolbarContent = function (show) {
  //show copy for a long summary issues
  if (this.toolbarCopy) {
    if (this.toolbarCopyContent) {
      if (show) {
        this.toolbarCopyContent.show();
      } else {
        this.toolbarCopyContent.hide();
      }

    } else {
      this.toolbarCopyContent = $(document.createElement("div")).addClass("fsi-toolbar-copy").html(this.container.html());
      this.parent.append(this.toolbarCopyContent);
    }

  }

};
charisma.smartui.Toolbar.prototype._update = function (hide) {
  this.toggleCssClass(hide);
  this.setTop();
  this.setWidth();
  this.calculateHeight();
};
charisma.smartui.Toolbar.prototype.calculateHeight = function () {
  this.currentDimensions[1] = this.shown ?this.container.outerHeight(true) :this.originalDimensions[1];
};
charisma.smartui.Toolbar.prototype.toggleCssClass = function (hide) {
  this.container[hide ?'removeClass' :'addClass'](charisma.smartui.Toolbar.CSS_UNPINNED_CLASS);
};
charisma.smartui.Toolbar.prototype.setTop = function () {
  if (this.verticalMargin > 0) {
    this.container.css("top", this.shown ?this.verticalMargin :"");
  }

};
charisma.smartui.Toolbar.prototype.setWidth = function (width) {
  var w = width ?width :(this.shown ?this.originalDimensions[0] :"");
  this.container.css({width: w});
};
charisma.smartui.Toolbar.prototype.updateWidth = function () {
  this.saveParentOffset();
  this.setWidth();
};
charisma.smartui.Toolbar.prototype.bindEvents = function () {
  var t = this;
  this.resizeHandler = function () {
    t.originalDimensions[0] = t.container.parent().width();
    if (t.shown) {
      t.setWidth(t.originalDimensions[0]);
    }

  };
  this.scrollHandler = function () {
    t.scroll();
  };
  this.win.resize(t.resizeHandler).scroll(t.scrollHandler);
};
charisma.smartui.Toolbar.prototype.getDimension = function () {
  //prevent overlap issue id
  return [this.currentDimensions[0], -this.currentDimensions[1]];
};
charisma.smartui.Toolbar.prototype.scroll = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "scroll", arguments);
};
charisma.smartui.Toolbar.prototype.update = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "update", arguments);
};
charisma.smartui.Toolbar.CSS_UNPINNED_CLASS = "toolbar-unpined";
charisma.smartui.Toolbar.EVENT_SHOW = "show";
charisma.smartui.Toolbar.EVENT_HIDE = "hide";
charisma.smartui.Toolbar.state_PINNED = {name: "PINNED", onexit: function () {
  this.currentDimensions = this.originalDimensions.slice();
}, scroll: function () {
  if (this.isFarScroll()) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.Toolbar.state_PINNED);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, charisma.smartui.Toolbar.state_UNPINNED);
    }

    return charisma.smartui.Toolbar.state_UNPINNED;
  }

  return false;
}, update: function () {
  if (true) {
    this.saveParentOffset();
    return ;
  }

  return false;
}};
charisma.smartui.Toolbar.state_UNPINNED = {name: "UNPINNED", onenter: function () {
  this._show();
}, onexit: function () {
  this._hide();
  this.currentDimensions = [0, 0];
}, scroll: function () {
  if (!this.isFarScroll()) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, charisma.smartui.Toolbar.state_UNPINNED);
    }

    return charisma.smartui.Toolbar.state_PINNED;
  }

  return false;
}, update: function () {
  if (true) {
    this.saveParentOffset();
    this.setWidth();
    return ;
  }

  return false;
}};
charisma.smartui.Toolbar.destroy = function (toolbar) {
  if (toolbar) {
    toolbar._hide();
    toolbar.container.removeClass(charisma.smartui.Toolbar.CSS_UNPINNED_CLASS);
    toolbar.win.unbind("resize", toolbar.resizeHandler).unbind("scroll", toolbar.scrollHandler);
    toolbar = null;
  }

};
charisma.smartui.SummaryToolbar = function (container, topMarin, commandToolbar) {
  charisma.smartui.SummaryToolbar.superclass.constructor.call(this, container, false, false, topMarin || 0);
  this.commandToolbar = commandToolbar;
};
{
  var F = new Function();
  F.prototype = charisma.smartui.Toolbar.prototype;
  charisma.smartui.SummaryToolbar.prototype = new F();
  charisma.smartui.SummaryToolbar.prototype.constructor = charisma.smartui.SummaryToolbar;
  charisma.smartui.SummaryToolbar.superclass = charisma.smartui.Toolbar.prototype;
}

charisma.smartui.SummaryToolbar.prototype._show = function () {
  charisma.smartui.SummaryToolbar.superclass._show.call(this);
  this.commandToolbar.container.addClass("noShadow");
};
charisma.smartui.SummaryToolbar.prototype._hide = function () {
  charisma.smartui.SummaryToolbar.superclass._hide.call(this);
  this.commandToolbar.container.removeClass("noShadow");
};
charisma.smartui.SidebarToolbar = function (container) {
  charisma.smartui.SidebarToolbar.superclass.constructor.call(this, container, false, true);
  this.handleFieldsCombo();
  this.fields = $(container).children().first();
  this.voters = $(container).find(".fsi__sidebar__bottom");
  this.scroll();
  this.handleResizeAndToggle();
};
{
  var F = new Function();
  F.prototype = charisma.smartui.Toolbar.prototype;
  charisma.smartui.SidebarToolbar.prototype = new F();
  charisma.smartui.SidebarToolbar.prototype.constructor = charisma.smartui.SidebarToolbar;
  charisma.smartui.SidebarToolbar.superclass = charisma.smartui.Toolbar.prototype;
}

charisma.smartui.SidebarToolbar.prototype.handleResizeAndToggle = function () {
  if (!this.voters[0]) {
    return ;
  }

  var timer;
  var it = this;
  $(window).on('resize', function (e) {
    window.clearTimeout(timer);
    timer = window.setTimeout(function () {
      it.balance();
    }, 100);
  });
    

  this.container.on(charisma.smartui.SidebarToolbar.TOGGLE_SIDEBAR_LIST, function () {
    it.setVotersTop();
  });
  window.setTimeout(function () {
    if (!it.shown) {
      it.balance();
    }

  }, 500);
    

};
charisma.smartui.SidebarToolbar.prototype.getMaxAvailableHeght = function () {
  return $(window).height() - this.container.offset().top + $(window).scrollTop();
};
charisma.smartui.SidebarToolbar.prototype.calculateBalancedHeight = function () {
  this.setVotersTopPosition(null);
  this.viewportHeight = this.getMaxAvailableHeght();
  this.votersHeight = this.voters.outerHeight();
  return this.viewportHeight < this.votersHeight + this.voters.position().top ?this.viewportHeight - this.votersHeight :'';
};
charisma.smartui.SidebarToolbar.prototype.setVotersTop = function () {
  if (!this.voters[0]) {
    return ;
  }

  this.setVotersBalanceCssClass(false);
  var height = this.calculateBalancedHeight();
  if (!height) {
    var it = this;
    window.setTimeout(function () {
      it.balance();
    }, 500);
  } else {
    this.setVotersTopPosition(height);
  }

  this.setVotersBalanceCssClass((typeof height === 'number'));
};
charisma.smartui.SidebarToolbar.prototype.setVotersBalanceCssClass = function (stick) {
  this.voters[stick === true ?'addClass' :'removeClass']("fsi__sidebar__bottom_sticky");
};
charisma.smartui.SidebarToolbar.prototype.setVotersTopPosition = function (newTop) {
  var top = newTop ?Math.max(0, newTop) :'';
  this.voters.css({'top': top, 'max-height': this.viewportHeight});
};
charisma.smartui.SidebarToolbar.prototype.reset = function () {
  this.fields.height('');
  this.setVotersTopPosition(null);
  this.setVotersBalanceCssClass(false);
};
charisma.smartui.SidebarToolbar.prototype.balance = function () {
  if (!this.voters[0]) {
    return ;
  }

  this.reset();
  var height = this.calculateBalancedHeight();
  if (height) {
    this.fields.height(height);
    this.setVotersBalanceCssClass(typeof height === 'number');
  }

};
charisma.smartui.SidebarToolbar.prototype.setHeightToParentElement = function () {
};
charisma.smartui.SidebarToolbar.prototype.isFarScroll = function () {
  var topScroll = this.doc.scrollTop();
  return (this.position.top - topScroll / 2) < topScroll;
};
charisma.smartui.SidebarToolbar.prototype.setWidth = function () {
  var width = "";
  var left = "";
  if (this.shown) {
    var parent = $(".vertical-properties:visible");
    if (parent.length > 0) {
      width = parent.width();
      left = parent.offset().left;
    }

  }

  this.container.css('left', left);
  charisma.smartui.SidebarToolbar.superclass.setWidth.call(this, width);
};
charisma.smartui.SidebarToolbar.prototype.handleFieldsCombo = function () {
  var doc = $(document);
  var setPosition = function () {
    jQuery.each(doc.find(".combobox.bind:visible"), function () {
      var cn = $(this).attr("_cn_");
      if (cn && $(document.getElementById(cn)).parent().hasClass("fsi-property")) {
        var cbc = cr.findById(cn);
        //recalculate position
        cbc && cbc.renderer && cbc.renderer.reset();
      }

    });
    jQuery.each(doc.find(".cf-input-container:visible"), function () {
      var calendar = cr.findById($(this).children().attr("id"));
      //hide calendar, cause there is no info about Layout direction
      calendar && calendar.layouter && calendar.kesc();
    });
  };
  this.container.bind(charisma.smartui.Toolbar.EVENT_SHOW, function () {
    doc.bind("scroll", setPosition);
    setPosition();
  }).bind(charisma.smartui.Toolbar.EVENT_HIDE, function () {
    doc.unbind("scroll", setPosition);
    setPosition();
  });
};
charisma.smartui.SidebarToolbar.prototype.setTop = function () {
  var it = this;
  var top = '';
  window.setTimeout(function () {
    var topToolbar = $(".fsi-top-toolbar.toolbar-unpined");
    if (topToolbar[0]) {
      top = $(".issues-nav-info")[0] ?topToolbar.outerHeight() :0;
    }

    if (top) {
      it.container.animate({top: top + 'px'}, 200);
    } else {
      it.container.css('top', top);
    }

  }, 150);
};
charisma.smartui.SidebarToolbar.prototype._show = function () {
  charisma.smartui.SidebarToolbar.superclass._show.call(this);
  this.balance();
};
charisma.smartui.SidebarToolbar.prototype._hide = function () {
  var it = this;
  charisma.smartui.SidebarToolbar.superclass._hide.call(this);
  window.setTimeout(function () {
    it.balance();
  }, 600);
};
charisma.smartui.SidebarToolbar.TOGGLE_SIDEBAR_LIST = 'toggleSidebarList';
charisma.smartui.CreateIssueToolbar = function (container, selector) {
  this.jQselector = selector;
  charisma.smartui.CreateIssueToolbar.superclass.constructor.call(this, container);
};
{
  var F = new Function();
  F.prototype = charisma.smartui.Toolbar.prototype;
  charisma.smartui.CreateIssueToolbar.prototype = new F();
  charisma.smartui.CreateIssueToolbar.prototype.constructor = charisma.smartui.CreateIssueToolbar;
  charisma.smartui.CreateIssueToolbar.superclass = charisma.smartui.Toolbar.prototype;
}

charisma.smartui.CreateIssueToolbar.prototype.setWidth = function () {
  var width = $(this.jQselector).width();
  var w = width ?width :(this.shown ?this.originalDimensions[0] :"");
  this.container.css({width: w});
};
