var viewImageAttachment = null;
charisma.smartui.ViewImageAttachment = function (baseUrl) {
  this.shown = false;
  this.baseUrl = baseUrl;
  this.setHandlers();
  this.bindImageClick();
  this.initHashListener();
  this.loadImageFromHash();
};
charisma.smartui.ViewImageAttachment.prototype.setHandlers = function () {
  var it = this;
  this.handleKeyDown = function (e) {
    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["Dismiss"])) {
      it.handleClose();
      return false;
    }

    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["ExpandIssue"])) {
      e.stopPropagation();
      it.navigate(true);
      return false;
    }

    if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["CollapseIssue"])) {
      e.stopPropagation();
      it.navigate(false);
      return false;
    }

  };
  this.handleClose = function () {
    it.getToken() && it.removeToken();
  };
  this.handleWinResize = function () {
    it.showCloseButton();
  };
  this.handleMouseClick = function (e) {
    var LEFT_MOUSE_BUTTON_CODE = 1;
    var MIDDLE_MOUSE_BUTTON_CODE = 2;
    if (it.img.get(0) == e.target || it.div.get(0) == e.target) {
      //navigate
      if (e.which === MIDDLE_MOUSE_BUTTON_CODE || e.metaKey) {
        window.open(it.img.attr('src'), '_blank');
        return false;
      }

      !e.shiftKey && e.which == LEFT_MOUSE_BUTTON_CODE && it.navigate(!e.ctrlKey);
    }

  };
  this.handleClickOutside = function (e) {
    if (it.img.get(0) !== e.target && it.prevArea.get(0) !== e.target && !$(e.target).hasClass("show-img-attach")) {
      it.handleClose();
    }

  };
};
charisma.smartui.ViewImageAttachment.prototype.bindImageClick = function () {
  var it = this;
  $(document).delegate("a.show-img-attach", "click", function (e) {
    if (e.which === 2 || e.metaKey || e.ctrlKey) {
      return true;
    }

    e.preventDefault();
    $(".popupComponent:visible").hide();
    it.currentId = it.escape(this.id);
    if (it.getToken()) {
      //navigate with keyboard
      it.currentId = null;
      it.bindEvents(false);
    }

    var href = $(this).attr("href").split("_persistent/").pop();
    Webr.util.PageStateStore.getInstance().put(charisma.smartui.ViewImageAttachment.KEY, href);
  });
};
charisma.smartui.ViewImageAttachment.prototype.initHashListener = function () {
  var it = this;
  Webr.util.HistoryDispatcher.getInstance().addListener({key: charisma.smartui.ViewImageAttachment.KEY, historyChanged: function () {
    var anchor = $("#" + it.currentId);
    if (!it.getToken()) {
      it.hide();
      return ;
    }

    if (!anchor.get(0)) {
      it.loadImageFromHash();
    } else {
      it.load(anchor.attr("href"));
    }

  }});
};
charisma.smartui.ViewImageAttachment.prototype.bindEvents = function (bind) {
  var it = this;
  if (bind) {
    this.container.bind("keydown", it.handleKeyDown);
    $(window).bind("resize", it.handleWinResize);
    $(document).bind("click", it.handleClickOutside);
  } else {
    this.container.unbind("keydown", it.handleKeyDown);
    $(window).unbind("resize", it.handleWinResize);
    $(document).unbind("click", it.handleClickOutside);
  }

  this.bindMouseClick(bind);
};
charisma.smartui.ViewImageAttachment.prototype.bindMouseClick = function (bind) {
  var it = this;
  var doc = $(document);
  if (bind) {
    doc.click(it.handleMouseClick);
  } else {
    doc.unbind("click", it.handleMouseClick);
  }

};
charisma.smartui.ViewImageAttachment.prototype.loadImageFromHash = function () {
  if (this.getToken()) {
    var imageUrl = decodeURIComponent(window.location.hash).split(charisma.smartui.ViewImageAttachment.KEY + "=").pop();
    if (imageUrl) {
      this.load(this.baseUrl + "_persistent/" + imageUrl);
    }

  }

};
charisma.smartui.ViewImageAttachment.prototype.create = function () {
  if (!this.container) {
    var it = this;
    this.img = common.util.Util.createElement("img", false, l10n('${l10n("ViewImageAttachment.js._Ctrl_Mouse_left_click_-_previous_next_image_nESC_-_close_image")}'));
    this.closeBtn = common.util.Util.createElement("a", "img-view-close-btn", "Hide").click(function (e) {
      e.which == 1 && it.handleClose();
    });
        

    this.createPrevArea();
    this.div = common.util.Util.createElement("div", "img-view-content");
        

    this.container = common.util.Util.createElement("div", "img-view").attr("tabindex", "1000").append(this.closeBtn).append(this.prevArea).append("<div class='" + "img-view-progress" + "'></div>").append(this.div.append(this.img));
        

    $(document.body).append(this.container);
    charisma.smartui.ViewImageAttachment.CONSTANT = [this.container.outerHeight() - this.container.height(), this.closeBtn.width()];
    charisma.smartui.ViewImageAttachment.CONSTANT[3] = parseInt(this.img.css("paddingLeft") + this.img.css("paddingRight"));
  }

};
charisma.smartui.ViewImageAttachment.prototype.createPrevArea = function () {
  var it = this;
  var doc = $(document);
  this.prevArea = common.util.Util.createElement("div", "img-view-prev", "Previous image").append("<div class='" + "img-view-prev-ico" + "'></div>");
    

  var prevAreaIconToggle = function (e) {
    if (e.ctrlKey) {
      it.prevArea.children().addClass("img-view-next-ico");
    } else {
      it.prevArea.children().removeClass("img-view-next-ico");
    }

    doc.one("keydown keyup", prevAreaIconToggle);
  };
  this.prevArea.hover(function () {
    //toggle prev/next icon on press a ctrl key
    doc.one("keydown", prevAreaIconToggle);
  }, function () {
    doc.unbind("keydown", prevAreaIconToggle);
        

  }).click(function (e) {
    e.which == 1 && it.navigate(e.ctrlKey);
  });
};
charisma.smartui.ViewImageAttachment.prototype.escape = function (str) {
  return str.replace(/\./g,"\\.");
};
charisma.smartui.ViewImageAttachment.prototype.navigate = function (next) {
  var getFileNameNoParameters = function (name) {
    return (name || "").split("?file")[0];
  };
  var name = getFileNameNoParameters(this.getToken());
  if (name) {
    var attachmentLinksArr = $("a.show-img-attach.panel-attach" + "[href*='" + (Webr.util.Util.isGecko ?encodeURIComponent(name) :name) + "']");
    if (attachmentLinksArr.length > 1) {
      var filteredLinksArr = attachmentLinksArr.filter(function (idx, link) {
        var currentImageName = (link.href || "").split("_persistent/").pop();
        currentImageName = getFileNameNoParameters(currentImageName);
        return currentImageName === name || currentImageName === encodeURIComponent(name);
      });
      if (filteredLinksArr.length > 0) {
        attachmentLinksArr = filteredLinksArr;
      }

    }

    if (attachmentLinksArr.length == 0) {
      //element not found
      return ;
    }

    var attachmentLink = attachmentLinksArr.first();
    if (this.currentId !== this.escape(attachmentLink.attr("id"))) {
      attachmentLink = attachmentLinksArr.last();
    }

    this.currentId = this.escape(attachmentLink.attr("id"));
    var currentAttachDiv = $("#" + this.currentId).parent().parent();
    var all = this.getAll();
        

    if (all.length > 1) {
      this.closeBtn.hide();
      this.bindMouseClick(false);
      var index = all.index(currentAttachDiv) + (next ?1 :-1);
      this.clear();
      all.eq(index < all.length ?index :0).children(".show-img-attach").click();
    }

        

  }

};
charisma.smartui.ViewImageAttachment.prototype.getAll = function () {
  return $(".attachment-list .img-attach");
};
charisma.smartui.ViewImageAttachment.prototype.getToken = function () {
  return Webr.util.PageStateStore.getInstance().get(charisma.smartui.ViewImageAttachment.KEY);
};
charisma.smartui.ViewImageAttachment.prototype.removeToken = function () {
  Webr.util.PageStateStore.getInstance().removeKey(charisma.smartui.ViewImageAttachment.KEY);
  this.clear();
};
charisma.smartui.ViewImageAttachment.prototype.isNew = function (src) {
  var attr = this.img.attr("src");
  return !attr || attr.indexOf(src) == -1;
};
charisma.smartui.ViewImageAttachment.prototype.initImage = function (src) {
  this.div.hide();
  this.img.removeAttr("class").removeAttr("style");
  if (this.isNew(src)) {
    this.toggleLoading(true);
    this.img.attr("src", src);
  } else {
    this.img.load();
  }

};
charisma.smartui.ViewImageAttachment.prototype.load = function (src) {
  var it = this;
  this.create();
  this.img.one("load", function () {
    info("Image loaded, show");
    it.show(src);
  }).error(function () {
    it.toggleLoading(false);
    it.hide();
    it.removeToken();
    Webr.event.PopupMessage.SMALL_INFO.show("Error loading image", 3000);
  });
  this.initImage(src);
};
charisma.smartui.ViewImageAttachment.prototype.hide = function () {
  this.mask.hide();
  this.container.hide();
  this.div.hide();
  this.bindEvents(false);
  $(window).scrollTop(charisma.smartui.ViewImageAttachment.CONSTANT[2]);
  this.container.blur();
  this.shown = false;
};
charisma.smartui.ViewImageAttachment.prototype.show = function (param) {
  this.toggleLoading(false);
  this.saveScroll();
  this.setZoom(this.getDimensions(param));
  this.showMask();
  this.container.show();
  this.div.fadeIn(50);
  this.bindEvents(true);
  this.showCloseButton();
  this.container.focus();
  this.shown = true;
  if (this.getAll().length > 1) {
    this.prevArea.show();
  } else {
    this.prevArea.hide();
  }

};
charisma.smartui.ViewImageAttachment.prototype.toggleLoading = function (show) {
  if (show) {
    this.div.prev().show();
  } else {
    this.div.prev().hide();
  }

};
charisma.smartui.ViewImageAttachment.prototype.showCloseButton = function () {
  var it = this;
  var showButtonAndResizePager = function () {
    var winWidth = $(window).width();
    it.closeBtn.css("left", Math.min(winWidth, it.div.offset().left + it.div.width() + charisma.smartui.ViewImageAttachment.CONSTANT[1] / 3)).fadeIn(100);
    var width = Math.ceil(winWidth / 2 - it.div.outerWidth() / 2) - charisma.smartui.ViewImageAttachment.CONSTANT[1];
    it.prevArea.width(width);
  };
    

  if (!this.isAnimated()) {
    showButtonAndResizePager();
  } else {
    var timer = window.setInterval(function () {
      if (!it.isAnimated()) {
        showButtonAndResizePager();
        window.clearInterval(timer);
      }

    }, 20);
  }

};
charisma.smartui.ViewImageAttachment.prototype.isAnimated = function () {
  return this.div.is(":animated");
};
charisma.smartui.ViewImageAttachment.prototype.saveScroll = function () {
  charisma.smartui.ViewImageAttachment.CONSTANT[2] = $(window).scrollTop();
};
charisma.smartui.ViewImageAttachment.prototype.showMask = function () {
  if (!this.mask) {
    this.mask = $(document.createElement("div")).append("<div class=\"" + "jt-dialog-mask" + "\"></div>").append("<div class=\"" + "img-view-help" + "\"><span class='" + "img-view-arr" + "'>&larr; </span>/<span class='" + "img-view-shortcut" + "'>" + l10n('${l10n("ViewImageAttachment.js.Ctrl_Mouse_click")}') + "</span>" + l10n('${l10n("ViewImageAttachment.js._-_previous_image")}') + "<span class='" + "img-view-arr" + "'>&rarr; </span>/<span class='" + "img-view-shortcut" + "'>" + l10n('${l10n("ViewImageAttachment.js.Mouse_click")}') + "</span>" + l10n('${l10n("ViewImageAttachment.js._-_next_image")}') + "<span class='" + "img-view-shortcut" + "'>" + l10n('${l10n("ViewImageAttachment.js.ESC")}') + "</span>" + l10n('${l10n("ViewImageAttachment.js._-_close_image")}') + "<span class='" + "img-view-shortcut" + "'>" + l10n('${l10n("ViewImageAttachment.js.Middle_click")}') + "</span>" + l10n('${l10n("ViewImageAttachment.js._-_open_image_in_a_separate_window")}') + "<span class='" + "img-view-shortcut" + "'>" + l10n('${l10n("ViewImageAttachment.js.Shift_Mouse_click")}') + "</span>" + l10n('${l10n("ViewImageAttachment.js._-_resize")}') + "</div>");
    $(document.body).prepend(this.mask);
  }

  this.mask.show();
};
charisma.smartui.ViewImageAttachment.prototype.getDimensions = function (param) {
  var hasParams = this.getHashParameters();
  if (hasParams.rw && hasParams.rh) {
    return {width: parseInt(hasParams.rw), height: hasParams.rh};
  }

  return null;
};
charisma.smartui.ViewImageAttachment.prototype.getHashParameters = function (key) {
  var res = {};
  var params;
  var hash = window.location.hash.substr(1);
  if (hash && hash.indexOf("file=") == -1) {
    hash = decodeURIComponent(hash);
  }

  params = hash.split("&");
  var val;
  for (var i = 0; i < params.length; i += 1) {
    val = params[i].split("=");
    res[val[0]] = val[1];
  }

  return res;
};
charisma.smartui.ViewImageAttachment.prototype.clear = function () {
  var hash = "";
  var toRemove = ["v", "c", "rw", "rh"];
  var params = this.getHashParameters();
  for (var i = 0; i < toRemove.length; ++i) {
    delete params[toRemove[i]];
  }

  for ( var name in params) {
    if (params[name] != undefined) {
      hash += name + "=" + params[name] + "&";
    }

  }

  window.location.hash = "#" + hash.replace(/&+$/, "");
};
charisma.smartui.ViewImageAttachment.prototype.setZoom = function (dim) {
  var it = this;
  if (dim) {
    var win = $(window);
    var leftScroll = win.scrollLeft();
    var winWidth = win.width();
    var winHeight = win.height();
    var isW = dim.width > winWidth;
    var isH = dim.height > winHeight;
    if (isW || isH) {
      var wideImage = winWidth / dim.width < winHeight / dim.height;
      var dimension = wideImage ?"width" :"height";
            

      this.handleZoomImage = function (e) {
        if (e.shiftKey || e === true) {
          if (it.img.hasClass("img-resized")) {
            it.img.removeAttr("style").addClass("img-orig").removeClass("img-resized");
          } else {
            //max image dimention is 80%
            it.img.addClass("img-resized").removeClass("img-orig").css(dimension, (wideImage ?winWidth :winHeight) * 0.8);
          }

          it.showCloseButton();
        }

      };
      this.handleZoomImage(true);
      this.img.click(it.handleZoomImage);
      this.setCursorOnHover();
    }

  } else {
    this.handleZoomImage && this.img.unbind("click", it.handleZoomImage);
  }

};
charisma.smartui.ViewImageAttachment.prototype.setCursorOnHover = function () {
  var it = this;
  var changeCursor = function (e) {
    if (e.shiftKey) {
      it.prevArea.children().addClass("img-view-next-ico");
    } else {
      it.prevArea.children().removeClass("img-view-next-ico");
    }

    $(document).one("keydown keyup", changeCursor);
  };
    

  this.img.hover(function () {
    $(document).one("keydown", changeCursor);
  }, function () {
    $(document).unbind("keydown", changeCursor);
  });
    

};
charisma.smartui.ViewImageAttachment.KEY = "viewimage";
charisma.smartui.ViewImageAttachment.CONSTANT = [];
charisma.smartui.ViewImageAttachment.isVisible = function () {
  return viewImageAttachment && viewImageAttachment.shown;
};
