cr.setTemplateBind("CreateTagDialog", function (path) {
  cr.ach(path, "createTagDlg", "keydown", function (event, data) {
    return event.handleEnterEsc(function () {
      $(cr.findInHandler(event, "" + "." + "createNewTag", [])).click();
    }, function () {
      cr.serverMethodCallInHandler(event, "" + "." + "methodCall_cancel", {});
    });
  });
  cr.ach(path, "cancelNewTag", "click", function (event, data) {
    cr.serverMethodCallInHandler(event, "" + "." + "methodCall_cancel", {});
  });
  cr.ach(path, "closeCreateTagDlg", "click", function (event, data) {
    cr.serverMethodCallInHandler(event, "" + "." + "methodCall_cancel", {});
  });
  cr.ach(path, "ts" + "." + "color", "click", function (event, data) {
    var cssClass = $(cr.getTarget(event)).attr('class');
    $(cr.findInHandler(event, "" + "." + "tagName", [])).attr('class', "jt-input" + ' ' + cssClass);
  });
  cr.ach(path, "createNewTag", "click", function (event, data) {
    if (cr.findInHandler(event, "" + "." + "tagName", []) && cr.findInHandler(event, "" + "." + "tagName", []).value && cr.findInHandler(event, "" + "." + "tagName", []).value.trim().length > 0) {
      cr.serverMethodCallInHandler(event, "" + "." + "methodCall_save", {}, {preventDoubleSubmit: true});
    } else {
      cr.findInHandler(event, "" + "." + "tagName", []).highlight(l10n('${l10n("CreateTagDialog.Name_is_required")}'));
    }

  });
  cr.ash(path, "ts" + "." + "color", "click", null);
  cr.ash(path, "visibleForGroup", "Load", {collectFormElements: false, hideLoadingPopup: true, processRecentOnly: true, preventDoubleSubmit: false});
  cr.ash(path, "updateableForGroup", "Load", {collectFormElements: false, hideLoadingPopup: true, processRecentOnly: true, preventDoubleSubmit: false});
  regCC(path, "visibleForGroup");
  regCC(path, "updateableForGroup");
  regdlg(path, "createTagDlg");
});
