Webr.rest.FileUploader = function (fileInput, settings) {
  this.successListeners = [];
  this.errorListeners = [];
  this.completeListeners = [];
  this.fileInput = fileInput;
  this.settings = settings;
  if (settings.success) {
    this.successListeners.push(settings.success);
  }

  if (settings.error) {
    this.errorListeners.push(settings.error);
  }

  if (settings.complete) {
    this.completeListeners.push(settings.complete);
  }

};
Webr.rest.FileUploader.prototype.abort = function (timeout) {
  this.aborted = true;
  this.unwrapHiddenForm();
  if (timeout) {
    this.clearTimeout();
  }

};
Webr.rest.FileUploader.prototype.complete = function (handler) {
  this.completeListeners.push(handler);
};
Webr.rest.FileUploader.prototype.fireSuccess = function (textStatus, responseText) {
  for (var i = 0; i < this.successListeners.length; ++i) {
    this.successListeners[i](textStatus, responseText);
  }

  for (var i = 0; i < this.completeListeners.length; ++i) {
    this.completeListeners[i](true, textStatus, responseText);
  }

};
Webr.rest.FileUploader.prototype.fireError = function (textStatus) {
  for (var i = 0; i < this.errorListeners.length; ++i) {
    this.errorListeners[i](textStatus);
  }

  for (var i = 0; i < this.completeListeners.length; ++i) {
    this.completeListeners[i](false, textStatus);
  }

};
Webr.rest.FileUploader.prototype.handleResponse = function (loadedFrame) {
  var htmlDocument = null;
  if (loadedFrame.contentWindow) {
    htmlDocument = loadedFrame.contentWindow.document;
  } else {
    htmlDocument = loadedFrame.contentDocument || window.frames[loadedFrame.id]["document"];
  }

  if (htmlDocument) {
    var errors = $(htmlDocument).children("error");
    if (errors.length > 0) {
      var message = errors.text();
      this.unwrapHiddenForm();
      this.fireError(message);
    } else {
      //TODO: different responses for differen dataTypes
      var responseText = $(htmlDocument).children();
      this.unwrapHiddenForm();
      this.fireSuccess("Success", responseText);
    }

  } else {
    this.unwrapHiddenForm();
    this.fireError("File upload failed: no response returned");
  }

};
Webr.rest.FileUploader.prototype.wrapHiddenForm = function () {
  var frameId = "fileUploader-iframe-" + Math.round(new Date().getTime() / 1000);
  var _this = this;
  $("body").after('<iframe width="0" height="0" style="display:none;" name="' + frameId + '" id="' + frameId + '"/>');
  $('#' + frameId).load(function () {
    if (!_this.aborted) {
      _this.clearTimeout();
      _this.handleResponse(this);
    }

  });
    

  //Wrap file input in form
  this.fileInput.wrap(function () {
    return '<form action="' + _this.settings.url + '" method="POST" enctype="multipart/form-data" target="' + frameId + '" />';
  }).after(function () {
    var html = '';
    for ( var key in _this.settings.params) {
      html += '<input type="hidden" name="' + key + '" value="' + _this.settings.params[key] + '" />';
    }

    return html;
  });
    

};
Webr.rest.FileUploader.prototype.unwrapHiddenForm = function () {
  this.fileInput.siblings().remove();
  this.fileInput.unwrap();
};
Webr.rest.FileUploader.prototype.setTimeout = function () {
  if (this.settings.timeout > 0) {
    var _this = this;
    this.timeoutHandler = window.setTimeout(function () {
      _this.timeoutHandler = null;
      _this.abort(true);
      _this.fireError("Upload request timeout");
    }, this.settings.timeout);
  }

};
Webr.rest.FileUploader.prototype.clearTimeout = function () {
  if (this.timeoutHandler) {
    window.clearTimeout(this.timeoutHandler);
  }

};
Webr.rest.FileUploader.upload = function (fileInput, settings) {
  var fileUploader = new Webr.rest.FileUploader(fileInput, settings);
    

  if (fileInput.val() == "") {
    fileUploader.fireError("File input is empty");
    return ;
  }

    

  if (!fileInput.attr("name")) {
    fileInput.attr("name", fileInput.attr("id"));
  }

    

  fileUploader.wrapHiddenForm();
  fileInput.parent("form").submit();
  fileUploader.setTimeout();
    

  return fileUploader;
};


var UploadSettings = {};
UploadSettings = function () {
};
UploadSettings.prototype.success = function (textStatus, response) {
};
UploadSettings.prototype.error = function (textStatus) {
};
UploadSettings.prototype.complete = function (success, textStatus, response) {
};


