Webr.component.BaseComboRenderer = function (mainElement) {
  this.rootElement = $(document.body);
  this.loading = $(document.createElement("div")).addClass("combobox-loading").hide();
  this.drawn = false;
  this.config = {minListHeight: 100, maxListHeight: 1000, containerClass: ""};
  var it = this;
  this.mainElement = $(mainElement);
};
Webr.component.BaseComboRenderer.prototype.setLayouter = function (layouter) {
  this.layouter = layouter;
};
Webr.component.BaseComboRenderer.prototype.getMainElement = function () {
  return this.mainElement;
};
Webr.component.BaseComboRenderer.prototype.getInputElement = function () {
  if (!(this.inputElement)) {
    this.inputElement = this.mainElement.find("input");
  }

  return this.inputElement;
};
Webr.component.BaseComboRenderer.prototype.getHeight = function () {
  return this.comboContainer.outerHeight(true);
};
Webr.component.BaseComboRenderer.prototype.setComboContainerPositionAndHeight = function (top, maxHeight, preffered) {
  this.getContainer().css({top: top});
  maxHeight = maxHeight < this.config.minListHeight ?this.config.minListHeight :maxHeight > this.config.maxListHeight ?this.config.maxListHeight :maxHeight;
  if (preffered > maxHeight) {
    this.listContainer.css({"max-height": maxHeight - this.getMainElement().outerHeight(true) - (this.extraContainer ?this.extraContainer.height() :0), "overflow-y": "scroll"});
  } else {
    this.listContainer.css({"max-height": "", "overflow-y": ""});
  }

};
Webr.component.BaseComboRenderer.prototype.setExtraContentPosition = function () {
  if (this.extraContainer) {
    this.extraContainer.css({bottom: this.listContainer.height()});
  }

};
Webr.component.BaseComboRenderer.prototype.setConfig = function (config) {
  this.config.containerClass = config.containerClass || this.config.containerClass;
  this.config.maxListHeight = config.maxListHeight || this.config.maxListHeight;
  this.config.minListHeight = config.minListHeight || this.config.minListHeight;
};
Webr.component.BaseComboRenderer.prototype.setRootElement = function (root) {
  this.rootElement = $(root);
};
Webr.component.BaseComboRenderer.prototype.getContainer = function () {
  return this.comboContainer;
};
Webr.component.BaseComboRenderer.prototype.addExtraContent = function (content) {
  if (!this.extraContents) {
    this.extraContents = new Webr.util.Set();
  }

  this.extraContents.add(content);
};
Webr.component.BaseComboRenderer.prototype.removeExtraContent = function (content) {
  if (this.extraContents) {
    this.extraContents.remove(content);
  }

};
Webr.component.BaseComboRenderer.prototype.countPosition = function () {
  return {top: this.getMainElement().offset().top, left: this.getMainElement().offset().left};
};
Webr.component.BaseComboRenderer.prototype.isAncestorOf = function (element) {
  return this.getMainElement().ancestorOf(element) || this.getContainer().ancestorOf(element);
};
Webr.component.BaseComboRenderer.prototype.getLoadingElement = function () {
  if (!(this.drawn)) {
    this.mainElement.find("input").after(this.loading);
  }

  return this.loading;
};
Webr.component.BaseComboRenderer.prototype.showLoading = function (timeout) {
  if (timeout) {
    var it = this;
    this.loadingTimer = window.setTimeout(function () {
      it.showLoading();
    }, timeout);
  } else {
    this.getLoadingElement().show();
  }

};
Webr.component.BaseComboRenderer.prototype.hideLoading = function () {
  if (this.loadingTimer) {
    window.clearTimeout(this.loadingTimer);
    this.loadingTimer = null;
  }

  //Fix WD-1401






  this.getLoadingElement().hide();
};
Webr.component.BaseComboRenderer.prototype.destroy = function () {
  //jQuery remove shoul cleanup all bindings
  //http://api.jquery.com/remove/
  this.getMainElement().remove();
};
Webr.component.BaseComboRenderer.prototype.move = function (direction, maxHeight, preffered) {
};
Webr.component.BaseComboRenderer.prototype.reset = function () {
};
Webr.component.BaseComboRenderer.prototype.draw = function (list) {
};
Webr.component.BaseComboRenderer.prototype.hide = function () {
  this.shadow.hide();
  this.comboContainer.hide();
  this.layouter.reset();
};
Webr.component.BaseComboRenderer.prototype.show = function () {
  this.comboContainer.show();
  this.shadow.show();
  this.layouter.fix(this.comboContainer.width(), this.getHeight());
  this.shadow.setHeight(this.getShadowHeight());
};
Webr.component.BaseComboRenderer.prototype.repaint = function () {
};
Webr.component.BaseComboRenderer.prototype.getShadowHeight = function () {
  var shadowHeight = this.listContainer ?Math.max(this.getContainer().outerHeight(), this.listContainer.outerHeight()) :this.getContainer().outerHeight();
  return shadowHeight - Webr.component.Shadow.SHADOW_DELTA;
};
Webr.component.RenderConfig = function () {
  this.containerClass = "customCss";
  this.maxListHeight = 1000;
  this.minListHeight = 100;
};
