Webr.component.ComboComponentBase = function (mainElement, renderer) {
  Webr.component.ComboComponentBase.superclass.constructor.call(this);
  this.inputElement = null;
  this.jQinputElement = null;
  this.mainElement = null;
  this.local = false;
  this.inited = false;
  this.onInitValueChanged = false;
  this.current_state = null;
  this.renderer = renderer;
  var input = renderer.getInputElement().get(0);
  //Apply extensions
  cr.applyExtension(input);
  this.inputElement = input;
  this.jQinputElement = $(input);
  this.mainElement = $(mainElement);
  //Register component in registry
  this.mainElement.data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE, this);
  this.componentName = mainElement.id.substring(3);
  this.registerTemplateRefreshAndHihlighter();
  this.local = this.mainElement.attr("local");
    {
    Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITIAL);
  }

  this.current_state = Webr.component.ComboComponentBase.state_INITIAL;
};
{
  var F = new Function();
  F.prototype = Webr.component.Component.prototype;
  Webr.component.ComboComponentBase.prototype = new F();
  Webr.component.ComboComponentBase.prototype.constructor = Webr.component.ComboComponentBase;
  Webr.component.ComboComponentBase.superclass = Webr.component.Component.prototype;
}

Webr.component.ComboComponentBase.prototype.init = function () {
  if (!this.inited) {
    //Unbind focus if exists
    this.jQinputElement.unbind("focus");
    this.inputElement.attachWatcher(false);
    this.inputElement.setWatcherDelay(0);
    var it = this;
    //bind
    this.jQinputElement.bind("valuechange", function () {
      it.valueChange();
    });
    this.jQinputElement.focus(function () {
      it.focus();
      it.jQinputElement.select();
    });
    this.jQinputElement.click(function () {
      it.jQinputElement.select();
      it.showRequested();
      return false;
    });
    this.jQinputElement.blur(function () {
      //We need this nlur to handle blur directly on input
      it.inputBlur();
    });
    Webr.util.Util.addKeyHandler(this.jQinputElement, function (event) {
      return it.handleKeys(event);
    });
    this.mouseDownFunction = function (event) {
      return it.mdown(event);
    };
    this.keyDownFunction = function (event) {
      if (event.isKey(Webr.util.Key.TAB)) {
        it.ktab(event);
      }

      if (event.isShift(Webr.util.Key.TAB)) {
        it.blur();
      }

    };
    this.inited = true;
  }

};
Webr.component.ComboComponentBase.prototype.registerTemplateRefreshAndHihlighter = function () {
  var it = this;
  //Unregister on unload (delete trash!!!)
  this.refreshListener = {beforeRefresh: function (tP) {
    if (it.componentName.indexOf(tP) == 0) {
      it.finalize();
    }

  }};
  Webr.event.RefreshCommandProcessor.addListener(this.refreshListener);
  //Unhighlight previous highlight
  this.inputElement.unHighlight();
  //override higlighter creator for input
  this.inputElement.createHighlighter = function (message) {
    return it.errorHighlighter = it.createHighlighter(message);
  };
};
Webr.component.ComboComponentBase.prototype.createHighlighter = function (message) {
  return new Webr.component.BaseComboboxHighlighter(this, message);
};
Webr.component.ComboComponentBase.prototype.finalize = function () {
  if (this.errorHighlighter) {
    this.errorHighlighter.destroy();
    this.errorHighlighter = null;
  }

  this.beforeDestroy();
  this.renderer.destroy();
  Webr.event.RefreshCommandProcessor.removeListener(this.refreshListener);
  this.refreshListener = null;
  delete this.refreshListener;
};
Webr.component.ComboComponentBase.prototype.handleBlur = function () {
  var d = $(Webr.util.Util.isIE ?document.body :document);
  d.mousedown(this.mouseDownFunction);
  Webr.util.Util.addKeyHandler(d, this.keyDownFunction);
};
Webr.component.ComboComponentBase.prototype.unhandleBlur = function () {
  var d = $(Webr.util.Util.isIE ?document.body :document);
  d.unbind("mousedown", this.mouseDownFunction);
  Webr.util.Util.removeKeyHandler(d, this.keyDownFunction);
};
Webr.component.ComboComponentBase.prototype.highlight = function (message) {
  this.inputElement.highlight(message);
};
Webr.component.ComboComponentBase.prototype.setFocusNoEvents = function () {
  this.inputElement.focus();
};
Webr.component.ComboComponentBase.prototype.handleKeys = function (event) {
  if (event.isKey(Webr.util.Key.ENTER)) {
    this.kenter(event);
  }

  if (event.isKey(Webr.util.Key.ESC)) {
    this.kesc(event);
  }

  if (event.isKey(Webr.util.Key.DOWN)) {
    this.kdown();
    return false;
  }

  if (event.isKey(Webr.util.Key.UP)) {
    this.kup();
    return false;
  }

  if (event.isKey(Webr.util.Key.PAGEDOWN)) {
    this.dataList.select_last();
    return false;
  }

  if (event.isKey(Webr.util.Key.PAGEUP)) {
    this.dataList.select_first();
    return false;
  }

  return this.fireKeyDown(event);
};
Webr.component.ComboComponentBase.prototype.loadRequired = function () {
};
Webr.component.ComboComponentBase.prototype.makeVisible = function () {
};
Webr.component.ComboComponentBase.prototype.getCurentOption = function () {
};
Webr.component.ComboComponentBase.prototype.makeHidden = function () {
};
Webr.component.ComboComponentBase.prototype.sync = function () {
};
Webr.component.ComboComponentBase.prototype.setSearchContext = function (value) {
};
Webr.component.ComboComponentBase.prototype.update = function (options, size, from, to, hidePaganation, pageSize, exactSize) {
};
Webr.component.ComboComponentBase.prototype.submit = function (option) {
};
Webr.component.ComboComponentBase.prototype.callLoading = function (prefix) {
};
Webr.component.ComboComponentBase.prototype.renderList = function () {
};
Webr.component.ComboComponentBase.prototype.createListWrapper = function () {
};
Webr.component.ComboComponentBase.prototype.showLoading = function (parent) {
  this.renderer.showLoading(500);
};
Webr.component.ComboComponentBase.prototype.hideLoading = function () {
  this.renderer.hideLoading();
};
Webr.component.ComboComponentBase.prototype.showRequested = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "showRequested", arguments);
};
Webr.component.ComboComponentBase.prototype.focus = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "focus", arguments);
};
Webr.component.ComboComponentBase.prototype.blur = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "blur", arguments);
};
Webr.component.ComboComponentBase.prototype.toggle = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "toggle", arguments);
};
Webr.component.ComboComponentBase.prototype.inputBlur = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "inputBlur", arguments);
};
Webr.component.ComboComponentBase.prototype.valueChange = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "valueChange", arguments);
};
Webr.component.ComboComponentBase.prototype.loaded = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "loaded", arguments);
};
Webr.component.ComboComponentBase.prototype.reload = function (s) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "reload", arguments);
};
Webr.component.ComboComponentBase.prototype.mdown = function (event) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mdown", arguments);
};
Webr.component.ComboComponentBase.prototype.keydown = function (event) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "keydown", arguments);
};
Webr.component.ComboComponentBase.prototype.kdown = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "kdown", arguments);
};
Webr.component.ComboComponentBase.prototype.kup = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "kup", arguments);
};
Webr.component.ComboComponentBase.prototype.kesc = function (e) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "kesc", arguments);
};
Webr.component.ComboComponentBase.prototype.kenter = function (e) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "kenter", arguments);
};
Webr.component.ComboComponentBase.prototype.ktab = function (e) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "ktab", arguments);
};
Webr.component.ComboComponentBase.prototype.drop = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "drop", arguments);
};
Webr.component.ComboComponentBase.prototype.mOptionClicked = function (option) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "mOptionClicked", arguments);
};
Webr.component.ComboComponentBase.prototype.applyButtonClicked = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "applyButtonClicked", arguments);
};
Webr.component.ComboComponentBase.prototype.beforeDestroy = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "beforeDestroy", arguments);
};
Webr.component.ComboComponentBase.state_INITIAL = {name: "INITIAL", onenter: function () {
  this.init();
}, focus: function () {
  if (true) {
    this.inputElement.watcher.focus();
    return Webr.component.ComboComponentBase.state_NOT_INITED_FOCUSED;
  }

  return false;
}, showRequested: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

    return Webr.component.ComboComponentBase.state_INITED_LOADING;
  }

  return false;
}, toggle: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

    return Webr.component.ComboComponentBase.state_INITED_LOADING;
  }

  return false;
}};
Webr.component.ComboComponentBase.state_NOT_INITED_FOCUSED = {name: "NOT_INITED_FOCUSED", showRequested: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

    return Webr.component.ComboComponentBase.state_INITED_LOADING;
  }

  return false;
}, inputBlur: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITIAL);
    }

    return Webr.component.ComboComponentBase.state_INITIAL;
  }

  return false;
}, kdown: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

    return Webr.component.ComboComponentBase.state_INITED_LOADING;
  }

  return false;
}, kup: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

    return Webr.component.ComboComponentBase.state_INITED_LOADING;
  }

  return false;
}, valueChange: function () {
  if (true) {
    this.onInitValueChanged = true;
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

    return Webr.component.ComboComponentBase.state_INITED_LOADING;
  }

  return false;
}, toggle: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

    return Webr.component.ComboComponentBase.state_INITED_LOADING;
  }

  return false;
}};
Webr.component.ComboComponentBase.state_INITED = {name: "INITED"};
Webr.component.ComboComponentBase.state_INITED_LOADING = {name: "INITED_LOADING", parentState: Webr.component.ComboComponentBase.state_INITED, onenter: function () {
  this.showLoading(this.jQinputElement);
  this.callLoading();
}, onexit: function () {
  this.hideLoading();
}, beforeDestroy: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITIAL);
    }

    return Webr.component.ComboComponentBase.state_INITIAL;
  }

  return false;
}, inputBlur: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITIAL);
    }

    return Webr.component.ComboComponentBase.state_INITIAL;
  }

  return false;
}, toggle: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITIAL);
    }

    return Webr.component.ComboComponentBase.state_INITIAL;
  }

  return false;
}, valueChange: function () {
  if (true) {
    this.onInitValueChanged = true;
    this.callLoading();
    return ;
  }

  return false;
}, loaded: function () {
  if (true) {
    this.fire(function (l) {
      l.updated();
    });
    if (this.onInitValueChanged) {
      this.setSearchContext(this.inputElement.value);
      this.onInitValueChanged = false;
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_LOADING);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_INITED_SHOWN;
  }

  return false;
}};
Webr.component.ComboComponentBase.state_INITED_HIDDEN = {name: "INITED_HIDDEN", parentState: Webr.component.ComboComponentBase.state_INITED, focus: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_FOCUSED);
    }

    return Webr.component.ComboComponentBase.state_INITED_FOCUSED;
  }

  return false;
}, showRequested: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_INITED_SHOWN;
  }

  return false;
}, drop: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITIAL);
    }

    return Webr.component.ComboComponentBase.state_INITIAL;
  }

  return false;
}, toggle: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_INITED_SHOWN;
  }

  return false;
}};
Webr.component.ComboComponentBase.state_INITED_FOCUSED = {name: "INITED_FOCUSED", parentState: Webr.component.ComboComponentBase.state_INITED, onenter: function () {
  this.fire(function (l) {
    l.focus();
  });
}, showRequested: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_INITED_SHOWN;
  }

  return false;
}, kdown: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_INITED_SHOWN;
  }

  return false;
}, kup: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_INITED_SHOWN;
  }

  return false;
}, reload: function (s) {
  if (true) {
    this.callLoading(s);
    return ;
  }

  return false;
}, valueChange: function () {
  if (true) {
    this.setSearchContext(this.inputElement.value);
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_INITED_SHOWN;
  }

  return false;
}, inputBlur: function () {
  if (true) {
    return Webr.component.ComboComponentBase.state_INITED_HIDDEN;
  }

  return false;
}, toggle: function () {
  if (true) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_INITED_SHOWN;
  }

  return false;
}};
Webr.component.ComboComponentBase.state_INITED_SHOWN = {name: "INITED_SHOWN", parentState: Webr.component.ComboComponentBase.state_INITED, onenter: function () {
  this.handleBlur();
  this.makeVisible();
  this.fire(function (l) {
    l.show();
  });
}, onexit: function () {
  this.fire(function (l) {
    l.hide();
  });
  this.unhandleBlur();
  this.makeHidden();
  this.sync();
}, mdown: function (event) {
  if (true) {
    if (!this.renderer.isAncestorOf(event.target)) {
      this.blur();
      return ;
    }

    this.setFocusNoEvents();
    return ;
  }

  return false;
}, valueChange: function () {
  if (true) {
    this.setSearchContext(this.inputElement.value);
    return ;
  }

  return false;
}, kenter: function (e) {
  if (!this.loadRequired()) {
    this.submit(this.dataList.getCurrentOption());
    e.preventDefault();
    e.stopImmediatePropagation();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_FOCUSED);
    }

    return Webr.component.ComboComponentBase.state_INITED_FOCUSED;
  }

  if (this.loadRequired()) {
    this.submit(this.dataList.getCurrentOption());
    e.preventDefault();
    e.stopImmediatePropagation();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_NOT_INITED_FOCUSED;
  }

  return false;
}, ktab: function (e) {
  if (!this.loadRequired()) {
    this.submit(this.dataList.getCurrentOption());
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_INITED_HIDDEN;
  }

  if (this.loadRequired()) {
    this.submit(this.dataList.getCurrentOption());
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITIAL);
    }

    return Webr.component.ComboComponentBase.state_INITIAL;
  }

  return false;
}, kdown: function () {
  if (true) {
    this.dataList.select_next();
    return ;
  }

  return false;
}, kup: function () {
  if (true) {
    this.dataList.select_prev();
    return ;
  }

  return false;
}, kesc: function (e) {
  if (!this.loadRequired()) {
    e.preventDefault();
    e.stopImmediatePropagation();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_FOCUSED);
    }

    return Webr.component.ComboComponentBase.state_INITED_FOCUSED;
  }

  if (this.loadRequired()) {
    e.preventDefault();
    e.stopImmediatePropagation();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_NOT_INITED_FOCUSED;
  }

  return false;
}, loaded: function () {
  if (true) {
    this.setFocusNoEvents();
    return ;
  }

  return false;
}, reload: function (s) {
  if (true) {
    this.callLoading(s);
    return ;
  }

  return false;
}, beforeDestroy: function () {
  if (!this.loadRequired()) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_FOCUSED);
    }

    return Webr.component.ComboComponentBase.state_INITED_FOCUSED;
  }

  if (this.loadRequired()) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_NOT_INITED_FOCUSED;
  }

  return false;
}, blur: function () {
  if (!this.loadRequired()) {
    this.fire(function (l) {
      l.blur();
    });
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_INITED_HIDDEN;
  }

  if (this.loadRequired()) {
    this.fire(function (l) {
      l.blur();
    });
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITIAL);
    }

    return Webr.component.ComboComponentBase.state_INITIAL;
  }

  return false;
}, toggle: function () {
  if (!this.loadRequired()) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_FOCUSED);
    }

    return Webr.component.ComboComponentBase.state_INITED_FOCUSED;
  }

  if (this.loadRequired()) {
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_NOT_INITED_FOCUSED;
  }

  return false;
}, mOptionClicked: function (option) {
  if (!this.loadRequired()) {
    this.submit(option);
    this.setFocusNoEvents();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_FOCUSED);
    }

    return Webr.component.ComboComponentBase.state_INITED_FOCUSED;
  }

  if (this.loadRequired()) {
    this.submit(option);
    this.setFocusNoEvents();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_NOT_INITED_FOCUSED;
  }

  return false;
}, applyButtonClicked: function () {
  if (!this.loadRequired()) {
    this.submit(null);
    this.setFocusNoEvents();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

        {
      Webr.stateMachine.stateMachineRuntime.handleOnEnter(this, Webr.component.ComboComponentBase.state_INITED_FOCUSED);
    }

    return Webr.component.ComboComponentBase.state_INITED_FOCUSED;
  }

  if (this.loadRequired()) {
    this.submit(null);
    this.setFocusNoEvents();
        {
      Webr.stateMachine.stateMachineRuntime.handleOnExit(this, Webr.component.ComboComponentBase.state_INITED_SHOWN);
    }

    return Webr.component.ComboComponentBase.state_NOT_INITED_FOCUSED;
  }

  return false;
}};
Webr.component.ComboComponentBase.findRoot = function (element) {
  return $(element).closest("div." + "jt-dialog").get(0) || document.body;
};
Webr.component.ComboComponentBase.safeHighlight = function (combo, message) {
  var c;
  if (combo.finalize) {
    //inited
    c = combo.jQinputElement;
  } else {
    //not inited
    c = $(combo).find("input").focus();
  }

  var element = c.get(0);
  //TODO: quick fix for binded combobox highlighter
  if (element && element.highlight) {
    element.highlight(message);
  } else {
    //No input found (this is not initialized binded combo)
    c = $(combo);
    var el = c.prev().get(0);
    var highlighter = el.highlighter;
    if (highlighter) {
      highlighter.destroy();
    }

    highlighter = new Webr.component.ElementHighlighter(el, message);
    highlighter.create();
    c.addRefreshListener(function () {
      if (highlighter) {
        highlighter.destroy();
      }

    });
  }

};
Webr.component.ComboComponentListener = function () {
  Webr.component.ComboComponentListener.superclass.constructor.call(this);
};
{
  var F = new Function();
  F.prototype = Webr.component.ComponentListener.prototype;
  Webr.component.ComboComponentListener.prototype = new F();
  Webr.component.ComboComponentListener.prototype.constructor = Webr.component.ComboComponentListener;
  Webr.component.ComboComponentListener.superclass = Webr.component.ComponentListener.prototype;
}

Webr.component.ComboComponentListener.prototype.show = function (source) {
};
Webr.component.ComboComponentListener.prototype.hide = function (source) {
};
Webr.component.ComboComponentListener.prototype.blur = function (source) {
};
Webr.component.ComboComponentListener.prototype.focus = function (source) {
};
Webr.component.ComboComponentListener.prototype.updated = function () {
};
Webr.component.ComboComponentListener.prototype.submitted = function (option, source) {
};
