cr.registerExtension("select", "HTMLSelectElement");
HTMLSelectElement.prototype.highlight = function (message, position, dismissOnChange, focus) {
  this.unHighlight();
  Webr.ErrorHighlighter.highlightError(this, message);
};
HTMLSelectElement.prototype.unHighlight = function () {
  //If highlighter already created, destroy it before continue
  if (this.highliter) {
    this.highliter.destroy();
    this.highliter = null;
  }

};
HTMLSelectElement.prototype.createHighlighter = function (message) {
  this.highliter = new Webr.ErrorHighlighter(this, message);
  return this.highliter;
};
