Webr.component.Shadow = function () {
};
Webr.component.Shadow.prototype.setHeight = function (height) {
};
Webr.component.Shadow.prototype.setWidth = function (width) {
};
Webr.component.Shadow.prototype.setTop = function (top) {
};
Webr.component.Shadow.prototype.setLeft = function (left) {
};
Webr.component.Shadow.prototype.show = function (el) {
};
Webr.component.Shadow.prototype.hide = function () {
};
Webr.component.Shadow.prototype.relayout = function (reverse) {
};
Webr.component.Shadow.prototype.remove = function () {
};
Webr.component.Shadow.EMPTY_SHADOW = new Webr.component.Shadow();
Webr.component.Shadow.SHADOW_DELTA = 6;
Webr.component.Shadow.getShadow = function (context, cssClass) {
  var shadow = Webr.component.Shadow.EMPTY_SHADOW;
  if (Webr.util.Util.isIE && Webr.util.Util.browserVersion < 9) {
    shadow = new Webr.component.IEShadow(context, cssClass);
  }

  return shadow;
};
Webr.component.IEShadow = function (context, cssClass) {
  Webr.component.IEShadow.superclass.constructor.call(this);
  this.current_state = null;
  this.context = context;
  this.createElement(cssClass);
  this.attachShadow();
  this.current_state = Webr.component.IEShadow.state_HIDDEN;
};
{
  var F = new Function();
  F.prototype = Webr.component.Shadow.prototype;
  Webr.component.IEShadow.prototype = new F();
  Webr.component.IEShadow.prototype.constructor = Webr.component.IEShadow;
  Webr.component.IEShadow.superclass = Webr.component.Shadow.prototype;
}

Webr.component.IEShadow.prototype.attachShadow = function () {
  var contextIsDialog = this.context.hasClass("jt-dialog");
  if (contextIsDialog) {
    this.context.children().first().before(this.container.css("z-index", -1));
  } else if (this.context.css("position").toLowerCase() == "static") {
    this.context.before(this.container.css("z-index", 0));
  } else {
    var zindex = this.context.css("z-index");
    this.context.after(this.container.css("z-index", zindex != "auto" ?zindex - 1 :zindex));
  }

};
Webr.component.IEShadow.prototype.createElement = function (cssClass) {
  this.container = $(document.createElement("div")).addClass(cssClass).css({left: this.context.css("left"), top: this.context.position().top});
  this.container.html("&nbsp;");
};
Webr.component.IEShadow.prototype.relayout = function (reverse) {
  if (reverse) {
    this.container.addClass("reversal");
  } else {
    this.container.removeClass("reversal");
  }

};
Webr.component.IEShadow.prototype.setHeight = function (height) {
  this.container.css({height: height});
};
Webr.component.IEShadow.prototype.setWidth = function (width) {
  this.container.css({width: width});
};
Webr.component.IEShadow.prototype.setTop = function (top) {
  this.container.css({top: top});
};
Webr.component.IEShadow.prototype.setLeft = function (left) {
  this.container.css({left: left});
};
Webr.component.IEShadow.prototype._show = function (visible) {
  if (this.container) {
    if (visible) {
      this.container.css({width: this.context.outerWidth()});
      this.container.show();
    } else {
      this.container.hide();
    }

  }

};
Webr.component.IEShadow.prototype.remove = function () {
  this.container.remove();
  delete this.context;
};
Webr.component.IEShadow.prototype.show = function (visible) {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "show", arguments);
};
Webr.component.IEShadow.prototype.hide = function () {
  Webr.stateMachine.stateMachineRuntime.handleEvent(this, "hide", arguments);
};
Webr.component.IEShadow.state_HIDDEN = {name: "HIDDEN", show: function (visible) {
  if (true) {
    var viz = visible ?visible :true;
    this._show(viz);
    return Webr.component.IEShadow.state_SHOWN;
  }

  return false;
}};
Webr.component.IEShadow.state_SHOWN = {name: "SHOWN", parentState: Webr.component.IEShadow.state_HIDDEN, hide: function () {
  if (true) {
    this._show(false);
    return Webr.component.IEShadow.state_SHOWN;
  }

  return false;
}};
