Webr.component.Ticker = function (ticker) {
  this.wasStarted = false;
  this.init(ticker);
};
Webr.component.Ticker.prototype.registerListeners = function () {
  var it = this;
  this.refreshListener = function () {
    it.jTicker.unbind();
    it.stop();
    info("Ticker stopped");
    it.jTicker.removeData(Webr.component.ComponentRegistry.COMPONENT_INSTANCE);
    it.jTicker = null;
    it.refreshListener = null;
  };
  this.jTicker.addRefreshListener(this.refreshListener);
};
Webr.component.Ticker.prototype.init = function (ticker) {
  this.jTicker = ticker;
  this.resetCounter();
  var interval = this.jTicker.attr("interval");
  if (interval) {
    this.start(parseInt(interval));
  }

  this.registerListeners();
  this.jTicker.data(Webr.component.ComponentRegistry.COMPONENT_INSTANCE, this);
};
Webr.component.Ticker.prototype.start = function (interval) {
  this.wasStarted = true;
  if (this.handler != null) {
    window.clearInterval(this.handler);
  }

  var t = this;
  this.handler = window.setInterval(function () {
    t.ontick(++t.tickCount);
  }, interval);
};
Webr.component.Ticker.prototype.stop = function () {
  if (this.handler != null) {
    window.clearInterval(this.handler);
    this.handler = null;
  }

};
Webr.component.Ticker.prototype.ontick = function (tickCount) {
  this.jTicker.trigger("tick", {config: {hideLoadingPopup: true}, tickCount: this.tickCount});
};
Webr.component.Ticker.prototype.resetCounter = function () {
  this.tickCount = 0;
};
Webr.component.Ticker.register = function (path, suffixName) {
  if (Webr.component.Ticker.tickers == undefined) {
    Webr.component.Ticker.tickers = new Webr.util.Map();
  }

  cr.forEach(path, suffixName, function () {
    var key = $(this).attr("id");
    var t = Webr.component.Ticker.tickers.get(key);
    if (t == undefined || t == null) {
      Webr.component.Ticker.tickers.put(key, new Webr.component.Ticker($(this)));
    } else {
      t.stop();
      //refresh listener could have been set to null by a refresh event
      if (t.refreshListener) {
        t.refreshListener();
      }

      t.init($(this));
    }

  });
};
var regT = Webr.component.Ticker.register;
