Webr.component.panel.Dialog = function (dialog) {
  this.visible = false;
  Webr.component.panel.Dialog.superclass.constructor.call(this, dialog);
  this.initConstants();
  this.setIeShadow();
  this.focusGetter = dialog.find("." + "jt-dialog-close");
  var title = dialog.children("." + "jt-panel-title").first();
  var it = this;
  dialog.draggable({containment: "window", handle: title, start: jQuery.proxy(this.onstartdrag, it), stop: jQuery.proxy(this.onstopdrag, it)});
};
{
  var F = new Function();
  F.prototype = Webr.component.panel.Panel.prototype;
  Webr.component.panel.Dialog.prototype = new F();
  Webr.component.panel.Dialog.prototype.constructor = Webr.component.panel.Dialog;
  Webr.component.panel.Dialog.superclass = Webr.component.panel.Panel.prototype;
}

Webr.component.panel.Dialog.prototype.initConstants = function () {
  this.constants = {vpWidth: $(window).width(), vpHeight: $(window).height(), scrollLeft: $(document).scrollLeft(), scrollTop: $(document).scrollTop()};
};
Webr.component.panel.Dialog.prototype.setIeShadow = function () {
  if (Webr.util.Util.isIE && Webr.util.Util.browserVersion < 9) {
    this.panel.addClass("jt-dialog-ie");
  }

};
Webr.component.panel.Dialog.prototype._setVisible = function (visible) {
  Webr.component.panel.Dialog.superclass.setVisible.call(this, visible);
};
Webr.component.panel.Dialog.prototype.getPanelBorders = function () {
  var pos = this.calculatePosition();
  return {top: pos.top + "px", left: pos.left + "px", width: this.panel.width() + "px", height: this.panel.height() + "px"};
};
Webr.component.panel.Dialog.prototype.getBorders = function (e) {
  var _e = $(e);
  return {top: _e.offset().top + "px", left: _e.offset().left + "px", width: _e.width() + "px", height: _e.height() + "px"};
};
Webr.component.panel.Dialog.prototype.setVisible = function (visible) {
  //do nothing if already visible or not
  if (this.visible == visible) {
    if (!visible) {
      //in case of dialog refresh, model div may stays visible
      Webr.component.panel.Dialog.setVisibleModalDiv(false);
    }

    return ;
  }

    

  Webr.component.panel.Dialog.VISIBLE_DIALOGS = Webr.component.panel.Dialog.VISIBLE_DIALOGS + (visible ?1 :-1);
    

  //show/hide dialog and modal div
  Webr.component.panel.Dialog.setVisibleModalDiv(visible);
  if (visible) {
    this.centerDialog();
  }

  Webr.component.panel.Dialog.superclass.setVisible.call(this, visible);
  this.focusGetter.focus();
  //clear error messages if closed
  if (!visible) {
    this.clearMessages();
  }

  this.visible = visible;
};
Webr.component.panel.Dialog.prototype.clearMessages = function () {
  Webr.ErrorMessage.closePopup();
};
Webr.component.panel.Dialog.prototype.centerDialog = function () {
  var pos = this.calculatePosition();
  this.panel.css({top: pos.top, left: pos.left});
};
Webr.component.panel.Dialog.prototype.calculatePosition = function () {
  var top = (this.constants.vpHeight - this.panel.height()) / 3;
  var left = (this.constants.vpWidth - this.panel.width()) / 2;
  return {top: Math.max(0, top), left: Math.max(0, left)};
};
Webr.component.panel.Dialog.prototype.onstartdrag = function () {
  this.panel.trigger("startdrag");
};
Webr.component.panel.Dialog.prototype.onstopdrag = function () {
  this.panel.trigger("stopdrag");
};
Webr.component.panel.Dialog.prototype.historyChanged = function (token) {
  if (this.visible) {
    //Send event to server
    this.onhistorychanged(token);
  }

};
Webr.component.panel.Dialog.ANIMATION_SPEED = 150;
Webr.component.panel.Dialog.MODAL_DIV_VISIBLE = false;
Webr.component.panel.Dialog.VISIBLE_DIALOGS = 0;
Webr.component.panel.Dialog.setVisibleModalDiv = function (show) {
  if (!show && ((!Webr.component.panel.Dialog.MODAL_DIV_VISIBLE) || Webr.component.panel.Dialog.VISIBLE_DIALOGS > 0)) {
    return ;
  }

  if (Webr.component.panel.Dialog.MODAL_DIV == null) {
    var d = document.createElement("div");
    $(d).addClass("jt-dialog-mask");
    Webr.component.panel.Dialog.MODAL_DIV = d;
  }

  if (show) {
    document.body.appendChild(Webr.component.panel.Dialog.MODAL_DIV);
  } else {
    document.body.removeChild(Webr.component.panel.Dialog.MODAL_DIV);
  }

  Webr.component.panel.Dialog.MODAL_DIV_VISIBLE = show;
};
Webr.component.panel.Dialog.setVisibleDialog = function (dialog, visible) {
  if (dialog && dialog.setVisible) {
    dialog.setVisible(visible);
  } else if (!visible) {
    //if we hide dialog and there's no dialog content 
    Webr.component.panel.Dialog.VISIBLE_DIALOGS = Webr.component.panel.Dialog.VISIBLE_DIALOGS - 1;
  }

  //just in case
  Webr.component.panel.Dialog.setVisibleModalDiv(visible);
};
Webr.component.panel.Dialog.registerDialog = function (path, name) {
  cr.forEach(path, name, function () {
    new Webr.component.panel.Dialog($(this));
  });
};
Webr.component.panel.Dialog.isModalVisible = function () {
  return Webr.component.panel.Dialog.MODAL_DIV_VISIBLE;
};
Webr.component.DialogConstants = function () {
};
var regdlg = Webr.component.panel.Dialog.registerDialog;
