Webr.util.HistoryDispatcher = function () {
  this.listeners = new Webr.util.Set();
  this.init();
};
Webr.util.HistoryDispatcher.prototype.init = function () {
  this.setCurrent(window.location.hash);
  this.startTicker();
};
Webr.util.HistoryDispatcher.prototype.startTicker = function () {
  //If it has native realisation
  //Watch doc on onhashchange HTML5
  if (window.onhashchange !== undefined && !(Webr.util.HistoryDispatcher.supportsOnlyFrameHistory())) {
    window.onhashchange = jQuery.proxy(this.historyChange, this);
  } else {
    window.setInterval(jQuery.proxy(this.historyChange, this), Webr.util.HistoryDispatcher.TIMER_INTERVAL);
  }

};
Webr.util.HistoryDispatcher.prototype.historyChange = function () {
  var oldHash = this.getCurrent();
  var newHash = this.setCurrent(window.location.hash);
  if (newHash != oldHash) {
    this.fireHistoryChanged();
  }

};
Webr.util.HistoryDispatcher.prototype.getCurrent = function () {
  return this.h;
};
Webr.util.HistoryDispatcher.prototype.setCurrent = function (hash) {
  return this.h = Webr.util.HistoryDispatcher.sanitize(hash);
};
Webr.util.HistoryDispatcher.prototype.addListener = function (l) {
  this.listeners.add(l);
};
Webr.util.HistoryDispatcher.prototype.removeListener = function (l) {
  this.listeners.remove(l);
};
Webr.util.HistoryDispatcher.prototype.fireHistoryChanged = function () {
  var store = Webr.util.PageStateStore.getInstance();
  var prevParams = store.getParams();
  store.update();
  this.listeners.forEach(function (listener) {
    if (listener.key) {
      var prev = prevParams.get(listener.key.toLowerCase());
      var now = store.get(listener.key);
      if (prev != now) {
        listener.historyChanged({current: now, prev: prev});
      }

    } else {
      listener.historyChanged();
    }

    return true;
  });
};
Webr.util.HistoryDispatcher.TIMER_INTERVAL = 250;
Webr.util.HistoryDispatcher.getInstance = function () {
  if (!Webr.util.HistoryDispatcher.dispatcher) {
    Webr.util.HistoryDispatcher.dispatcher = Webr.util.HistoryDispatcher.supportsOnlyFrameHistory() ?new Webr.util.IE7HistoryDispatcher() :new Webr.util.HistoryDispatcher();
  }

  return Webr.util.HistoryDispatcher.dispatcher;
};
Webr.util.HistoryDispatcher.supportsOnlyFrameHistory = function () {
  //Check that this is not IE 7 or CompatMode of IE8
  if (Webr.util.Util.isIE) {
    return !(window.onhashchange !== undefined && document.documentMode > 7);
  }

  return false;
};
Webr.util.HistoryDispatcher.sanitize = function (href) {
  return href.replace(/^#/, "");
};
Webr.util.IE7HistoryDispatcher = function () {
  Webr.util.IE7HistoryDispatcher.superclass.constructor.call(this);
};
{
  var F = new Function();
  F.prototype = Webr.util.HistoryDispatcher.prototype;
  Webr.util.IE7HistoryDispatcher.prototype = new F();
  Webr.util.IE7HistoryDispatcher.prototype.constructor = Webr.util.IE7HistoryDispatcher;
  Webr.util.IE7HistoryDispatcher.superclass = Webr.util.HistoryDispatcher.prototype;
}

Webr.util.IE7HistoryDispatcher.prototype.init = function () {
  this.setCurrent(window.location.hash);
  //init frame before start ticker
  this.initFrame();
};
Webr.util.IE7HistoryDispatcher.prototype.initFrame = function () {
  var it = this;
  var frameId = Webr.util.IE7HistoryDispatcher.IFRAME_ID;
  this.frame = document.createElement("iframe");
  this.frame.id = frameId;
  this.frame.name = frameId;
  this.frame.tabindex = -1;
  this.frame.style.position = "absolute";
  this.frame.style.left = "-10000px";
  this.frame.style.top = "-10000px";
  this.frame.style.display = "none";
  this.frame.src = "javascript:false;";
  document.body.appendChild(this.frame);
  document.frames[frameId].name = frameId;
  var handler = function () {
    it.frame.detachEvent("onload", handler);
    //be sure to detach event before update frame to prevent stack overflow
    it.update(it.getCurrent());
    //start ticker only after frame load
    it.startTicker();
  };
  this.frame.attachEvent("onload", handler);
};
Webr.util.IE7HistoryDispatcher.prototype.getWindow = function () {
  return this.frame.contentWindow;
};
Webr.util.IE7HistoryDispatcher.prototype.getFrameHash = function () {
  return Webr.util.HistoryDispatcher.sanitize(this.getWindow().location.hash);
};
Webr.util.IE7HistoryDispatcher.prototype.getWindowHash = function () {
  return Webr.util.HistoryDispatcher.sanitize(window.location.hash);
};
Webr.util.IE7HistoryDispatcher.prototype.setCurrent = function (hash) {
  return this.currentFrameHash = Webr.util.IE7HistoryDispatcher.superclass.setCurrent.call(this, hash);
};
Webr.util.IE7HistoryDispatcher.prototype.update = function (hash) {
  var myDoc = this.getWindow().document;
  this.fixTitle(myDoc);
  //Opening the Iframe's document after it has been closed is what
  //actually adds a histoy entry.
  myDoc.open();
  myDoc.close();
  this.getWindow().location.hash = hash;
};
Webr.util.IE7HistoryDispatcher.prototype.historyChange = function () {
  var frameHash = this.getFrameHash();
  var locationHash = this.getWindowHash();
  if (frameHash != locationHash) {
    if (locationHash === this.getCurrent()) {
      //User clicked on back button
      this.setCurrent(frameHash);
      window.location.hash = frameHash;
    } else {
      this.setCurrent(locationHash);
      this.update(locationHash);
    }

    this.fireHistoryChanged();
  }

};
Webr.util.IE7HistoryDispatcher.prototype.fixTitle = function (doc) {
  //Set good title in history
  try {
    doc.title = document.title;
  } catch (e) {
    //IE sometimes throws "Unspecified error"
  }

};
Webr.util.IE7HistoryDispatcher.IFRAME_ID = "__frame_history__";
Webr.util.HistoryChangeListener = function () {
};
Webr.util.HistoryChangeListener.prototype.historyChanged = function (token) {
};
Webr.util.HistoryToken = function () {
};
