var attachFileDialog = null;


var AttachFileDialog = {};
AttachFileDialog = function (windowId, maxFileSize, isIE9) {
  AttachFileDialog.superclass.constructor.call(this, "#attachFileDialog", null);
  attachFileDialog = this;
  this.isIE9 = isIE9;
  this.restClient = new Webr.rest.Client(Webr.Event.rootUrl, Ajax.ajaxSettings());
  this.windowId = windowId;
  this.maxFileSize = maxFileSize;
};
{
  var F = new Function();
  F.prototype = charisma.BaseDialog.prototype;
  AttachFileDialog.prototype = new F();
  AttachFileDialog.prototype.constructor = AttachFileDialog;
  AttachFileDialog.superclass = charisma.BaseDialog.prototype;
}

AttachFileDialog.prototype.initialize = function () {
  var it = this;
  this.fileInput = $("#attachFiles");
  this.fileInput.change(function () {
    if (it.setupPermittedGroup) {
      it.updateFilesList();
    } else {
      var f = $(this).prop('files');
      it.currentFileSize = 0;
      if (f) {
        for (var i = 0; i < f.length; ++i) {
          it.currentFileSize += f[i].size;
        }

      }

      it.attachFile();
    }

    if (it.isIE9) {
      it.fileInput.setVisible(false);
    }

  });
  $("#selectAttachmentsBtn").click(function (evt) {
    evt.preventDefault();
    evt.stopImmediatePropagation();
    it.fileInput.click();
  });
    

  var helper = charisma.ComboBoxHelper.create(this.permittedGroupController, "", {load: function (cbh) {
    return cbh.loadValuesFromRest(it.restClient.resource({p: "issueInternal"}).method("get", {p: ["issueInternal", "visibilityGroups", it.issueId]}).getUrl());
  }, multi: true, dataParser: function (data, textStatus, jqXHR) {
    var options = [];
    if (jQuery.isArray(data)) {
      var dataItems = data;
      for (var i = 0; i < dataItems.length; ++i) {
        var dataItem = dataItems[i];
        var item = {text: dataItem.name, id: i + "", empty: false};
        item["entityId"] = dataItem.entityId;
        options.push(item);
      }

    }

    return options;
  }});
  this.permittedGroupControllerHelper = helper;
  helper.insideDialog = true;
};
AttachFileDialog.prototype.show = function (onSave, setupPermittedGroup, issueId, commentId) {
  this.resetState();
  this.returnFocus = onSave;
  this.setupPermittedGroup = setupPermittedGroup;
  this.issueId = issueId;
  this.commentId = commentId;
  if (!(this.fileInput)) {
    this.initialize();
  }

  if (!setupPermittedGroup && !this.isIE9) {
    this.fileInput.click();
  } else {
    this.selectAttachmentsBtn.setVisible(true);
    $("#attachFileDialog .jt-panel-title").text(l10n('${l10n("AttachFileDialog.js.Attach_file_to")}') + this.getIssueId(true));
    if (this.isIE9 && !setupPermittedGroup) {
      this.permittedGroupFieldset.setVisible(false);
    }

    this.loadDlg();
  }

};
AttachFileDialog.prototype.loadDlg = function () {
  AttachFileDialog.superclass.show.call(this);
  this.updateFilesList();
};
AttachFileDialog.prototype.updateFilesList = function () {
  if (!this.files) {
    this.files = [];
  }

  var inputs = this.fileInput.prop('files');
  if (inputs) {
    for (var i = 0; i < inputs.length; ++i) {
      this.files.push(inputs[i]);
    }

    for (var i = 0; i < inputs.length; ++i) {
      var name = inputs[i].name;
      var size = FileUtils.getFileSizePresentation(inputs[i].size);
      var elemStr = "<li";
      var maxFileSizeExceeded = this.maxFileSize < inputs[i].size;
      if (maxFileSizeExceeded) {
        elemStr += " class='yt-uploaded-file-list_error' title='" + AttachFileDialog.FILE_SIZE_EXCEEDED + "'";
      }

      elemStr += "><span class='yt-uploaded-file-list__name' style='text-overflow:ellipsis'>" + name + "</span><span class='yt-uploaded-file-list__size'>" + '&nbsp;' + size + '</span>';
      if (window.FormData) {
        elemStr += "<span class='yt-uploaded-file-list__remove ring-font-icon ring-font-icon_close'></span>";
      }

      elemStr += "</li>";
      this.filesList.append(elemStr);
    }

    var self = this;
    if (inputs.length > 0) {
      $('.' + "yt-uploaded-file-list__remove").click(function (evt) {
        evt.stopImmediatePropagation();
        evt.preventDefault();
        $(this).parent().addClass("yt-uploaded-file-list_removed");
        self.updateTotalFileSize();
      });
      this.updateTotalFileSize();
    }

  } else {
    var name = this.fileInput.val();
    if (name) {
      this.filesList.append("<li><span class='yt-uploaded-file-list__name' style='text-overflow:ellipsis'>" + name.split("\\").pop() + "</span></li>");
      this.files = [this.fileInput];
    }

  }

  if (this.files.length > 0) {
    if (window.FormData) {
      this.selectAttachmentsBtn.text(l10n('${l10n("AttachFileDialog.js.Add_more_files")}'));
    } else {
      this.selectAttachmentsBtn.setVisible(false);
    }

  }

};
AttachFileDialog.prototype.updateTotalFileSize = function () {
  this.currentFileSize = 0;
  var fileListItems = this.filesList.children();
  for (var i = 0; i < this.files.length; ++i) {
    if (!($(fileListItems[i]).hasClass("yt-uploaded-file-list_removed"))) {
      this.currentFileSize += this.files[i].size;
    }

  }

  if (!this.fileSizeLimit) {
    this.fileSizeLimit = $("." + "sb-add-filesize-limit_attach-dialog");
  }

  this.fileSizeLimit.text(l10n('${l10n("AttachFileDialog.js.Current_upload_size")}') + (FileUtils.getFileSizePresentation(this.currentFileSize)) + " (" + l10n('${l10n("AttachFileDialog.js.Maximum")}') + FileUtils.getFileSizePresentation(this.maxFileSize) + ")");
  if (this.currentFileSize > this.maxFileSize) {
    this.fileSizeLimit.addClass("sb-add-filesize-limit_attach-dialog_error");
  } else {
    this.fileSizeLimit.removeClass("sb-add-filesize-limit_attach-dialog_error");
  }

};
AttachFileDialog.prototype.init = function (id) {
  AttachFileDialog.superclass.init.call(this, id);
  var it = this;
  this.filesList = $("#selectedFiles");
  this.permittedGroupController = $("#attachmentVisibleForGroup");
  this.selectAttachmentsBtn = $("#selectAttachmentsBtn");
  this.permittedGroupFieldset = $(".yt-attach-file-dialog__permitted-group-fieldset");
};
AttachFileDialog.prototype.close = function () {
  this.resetState();
  AttachFileDialog.superclass.close.call(this);
};
AttachFileDialog.prototype.submit = function () {
  this.attachFile();
};
AttachFileDialog.prototype.onSuccess = function (issueId, commentId) {
  this.toggleView(false);
  Webr.event.PopupMessage.SYSTEM.show(l10n('${l10n("AttachFileDialog.js.File_s_attached_to")}') + " " + ((commentId) ?l10n('${l10n("AttachFileDialog.js.comment_draft")}') :issueId), 3000);
  this.fileInput.val("");
  this.close();
};
AttachFileDialog.prototype.onError = function (data) {
  this.toggleView(false);
  var text = data.statusText;
  if (text === undefined) {
    if (typeof data === 'string') {
      text = data;
    } else {
      console.warn("Attach file error: ", data);
      text = l10n('${l10n("AttachFileDialog.js.unexpected_end_of_file_This_error_may_be_caused_by_an_explicit_limit_set_on_reverse_proxy_Refer_to_the_corresponding_documentation_on_how_to_increase_it")}');
    }

  }

  Webr.event.PopupMessage.ERROR.show(l10n('${l10n("AttachFileDialog.js.Can_not_attach_file")}') + " " + text);
};
AttachFileDialog.prototype.toggleView = function (progress) {
  if (progress) {
    $("#attachFileProgress").addClass("sb-invisible");
    $("#attachFileProgress").removeClass("sb-invisible");
  } else {
    $("#attachFileProgress").removeClass("sb-invisible");
    $("#attachFileProgress").addClass("sb-invisible");
  }

};
AttachFileDialog.prototype.attachFile = function (file) {
  if (!file) {
    file = this.fileInput;
  }

  if (!(file.val())) {
    this.close();
    return ;
  }

  if (this.currentFileSize > this.maxFileSize) {
    Webr.event.PopupMessage.SYSTEM.show(AttachFileDialog.FILE_SIZE_EXCEEDED, 5000);
    return ;
  }

    

  var it = this;
  it.toggleView(true);
  var issueId = it.getIssueId();
  var issueIdPresentation = it.getIssueId(true);
  var group;
  var idBased = false;
  if (this.setupPermittedGroup) {
    var mb = it.permittedGroupControllerHelper.combo;
    var currentIds = mb.currentCheckedIds;
    var dataListItems = mb.dataList ?mb.dataList.options :[];
    group = '';
    var first = true;
    for (var i = 0; i < dataListItems.length; i = i + 1) {
      var option = dataListItems[i].option;
      if (currentIds.indexOf(option.id) >= 0) {
        if (first) {
          first = false;
        } else {
          group += ',';
        }

        var entityId = option["entityId"];
        if (entityId) {
          group += entityId;
          idBased = true;
        } else {
          group += option.text;
        }

      }

    }

  } else {
    group = undefined;
  }

  var content = file;
  if (this.setupPermittedGroup && window.FormData) {
    content = new FormData();
    var hasFiles = false;
    var fileListItems = this.filesList.children();
    for (var i = 0; i < this.files.length; ++i) {
      var fileListItem = $(fileListItems[i]);
      if (!(fileListItem.hasClass("yt-uploaded-file-list_removed") || fileListItem.hasClass("yt-uploaded-file-list_error"))) {
        content.append(this.files[i].name, this.files[i]);
        hasFiles = true;
      }

    }

    if (!hasFiles) {
      this.close();
      return ;
    }

  }

  Webr.event.PopupMessage.SYSTEM.show('${l10n("Connection.Loading")}');
  var params = {commentId: it.commentId, issueId: issueId, error: function (status) {
    Webr.event.PopupMessage.SYSTEM.hide();
    it.onError(status);
  }, success: function (param1, param2, param3) {
    it.onSuccess(issueIdPresentation, it.commentId);
  }, content: content, windowId: it.windowId};
  if (idBased) {
    params.permittedGroupIds = group;
  } else {
    params.permittedGroup = group;
  }

  AttachActionsUtils.saveFiles(params);
};
AttachFileDialog.prototype.resetState = function () {
  if (!this.fileInput) {
    return ;
  }

  this.issueId = null;
  this.commentId = null;
  this.fileInput.replaceWith(this.fileInput = this.fileInput.clone(true));
  this.fileInput.setVisible(true);
  this.files = [];
  this.selectAttachmentsBtn.text(l10n('${l10n("AttachFileDialog.js.Select_files")}'));
  var multibux = this.permittedGroupControllerHelper.combo;
  if (multibux.dataList) {
    multibux.defaultCheckedIds = [];
    multibux.reset();
    multibux.hideOptions();
  }

  this.permittedGroupFieldset.setVisible(true);
  this.filesList.html("");
  this.updateTotalFileSize();
};
AttachFileDialog.prototype.fixDrag = function () {
  this.dialog.panel.draggable({handle: ".jt-panel-title"});
};
AttachFileDialog.prototype.getIssueId = function (presntation) {
  if (this.issueId) {
    if (presntation && this.issueId == commonController.getFocusedIssueId()) {
      return commonController.getFocusedPresentationIssueId();
    }

    return this.issueId;
  }

  return (presntation) ?commonController.getFocusedPresentationIssueId() :commonController.getFocusedIssueId();
};
AttachFileDialog.FILE_SIZE_EXCEEDED = l10n('${l10n("AttachFileDialog.js.File_size_exceeded_max_upload_size")}');
