charisma.BaseDialog = function (id, returnFocus) {
  if (id) {
    this.init(id);
  }

  this.returnFocus = returnFocus;
  this.documentHandlerOnKeyRepeatable = jQuery.proxy(this.onkeyrepeatable, this);
  this.documentHandlerOnKeyDown = jQuery.proxy(this.onkeydown, this);
};
charisma.BaseDialog.prototype.onkeyrepeatable = function (e) {
  if (Webr.util.Key.isApplicable(e, SuggestKeyStrokes["Close"])) {
    this.close();
    return false;
  }

    

  if (Webr.util.Key.isApplicable(e, SmartUIShortCuts["Submit"])) {
    this.submit();
    return false;
  }

    

  return true;
};
charisma.BaseDialog.prototype.onkeydown = function (e) {
  return true;
};
charisma.BaseDialog.prototype.show = function () {
  if (!this.dialog.isVisible()) {
    this.dialog.setVisible(true);
  }

  this.handleKeyboard();
};
charisma.BaseDialog.prototype.handleKeyboard = function () {
  $(document).keyrepeatable(this.documentHandlerOnKeyRepeatable);
  $(document).keydown(this.documentHandlerOnKeyDown);
};
charisma.BaseDialog.prototype.unhandleKeyboard = function () {
  $(document).unbind("keydown", this.documentHandlerOnKeyDown);
    

  if (Webr.util.Util.isIE || Webr.util.Util.isWebkit) {
    $(document).unbind("keydown", this.documentHandlerOnKeyRepeatable);
  } else {
    $(document).unbind("keypress", this.documentHandlerOnKeyRepeatable);
  }

};
charisma.BaseDialog.prototype.close = function () {
  this.unhandleKeyboard();
  this.dialog.setVisible(false);
  if (this.returnFocus) {
    if (this.returnFocus instanceof Function) {
      this.returnFocus();
    } else {
      $(this.returnFocus).focus();
    }

  }

};
charisma.BaseDialog.prototype.init = function (id) {
  var d = $(id);
  this.dialog = new Webr.component.panel.Dialog(d);
  d.find(".yt-btn-submit, .sb-btn-submit").click(jQuery.proxy(this.submit, this));
  d.find(".sb-btn-default, .sb-dlg-close, .jt-dialog-close, .yt-btn-close").click(jQuery.proxy(this.close, this));
  this.fixDrag();
};
charisma.BaseDialog.prototype.fixDrag = function () {
  //fix drag area
  this.dialog.panel.draggable({handle: ".sb-dlg-handler"});
};
charisma.BaseDialog.prototype.submit = function () {
  this.close();
};
