/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.webr.userManagement.runtime;

import javax.servlet.http.HttpServletRequest;
import jetbrains.mps.webr.runtime.requestProcessor.ResponseFactory;
import jetbrains.mps.webr.runtime.uri.QueryParameter;
import jetbrains.mps.webr.userManagement.runtime.RedirectAction;
import jetbrains.mps.webr.userManagement.runtime.SecurityNavigator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webr.framework.controller.BaseApplication;
import webr.framework.runtime.response.ResponseAction;
import webr.framework.url.UrlUtil;

public class TemplateRedirectAction
implements RedirectAction {
    protected static Log log = LogFactory.getLog(TemplateRedirectAction.class);
    private String myLoginTemplate;

    @Override
    public ResponseAction doRedirect(SecurityNavigator navigator) {
        this.saveAfterLoginUrl(navigator);
        String loginUrl = UrlUtil.getHtmlTemplateUri((String)this.getLoginTemplate(), (String)"", (QueryParameter[])new QueryParameter[0]);
        return ResponseFactory.getInstance().getRedirectResponse(loginUrl);
    }

    private void saveAfterLoginUrl(SecurityNavigator navigator) {
        HttpServletRequest request = BaseApplication.getRequest();
        if (request.getMethod().equalsIgnoreCase("GET")) {
            StringBuffer requestURL = request.getRequestURL();
            if (TemplateRedirectAction.isNotEmpty_9jxdme_a0b0b0b(request.getQueryString())) {
                requestURL.append('?').append(request.getQueryString());
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Saved requested url: " + requestURL.toString()));
            }
            navigator.saveRequestedUrl(requestURL.toString());
        }
    }

    public String getLoginTemplate() {
        return this.myLoginTemplate;
    }

    public void setLoginTemplate(String value) {
        this.myLoginTemplate = value;
    }

    public static boolean isNotEmpty_9jxdme_a0b0b0b(String str) {
        return str != null && str.length() > 0;
    }
}

