/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.persistence.listener;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.charisma.customfields.complex.common.XdBundleProjectCustomField;
import jetbrains.charisma.customfields.persistence.XdCustomFieldPrototype;
import jetbrains.charisma.customfields.persistence.fields.RemoveFieldHandler;
import jetbrains.charisma.customfields.persistence.fields.XdField;
import jetbrains.charisma.customfields.persistence.fields.XdFieldBundle;
import jetbrains.charisma.customfields.persistence.fields.XdProjectVersion;
import jetbrains.youtrack.agile.persistence.XdAgile;
import jetbrains.youtrack.agile.persistence.XdSprint;
import jetbrains.youtrack.agile.persistence.XdSprintKt;
import jetbrains.youtrack.agile.persistence.listener.AgileEntityListener;
import jetbrains.youtrack.agile.persistence.listener.SprintFieldValueListener;
import jetbrains.youtrack.agile.persistence.listener.SyncFieldUtilKt;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0017\u0018\u0000 \u001c2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0002H\u0002J\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\u0006\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0002J\u001c\u0010\u0016\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00022\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0015H\u0016J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0002H\u0016J\u001c\u0010\u001a\u001a\u00020\u001b*\u00020\u000e2\u000e\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u0015H\u0002R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001d"}, d2={"Ljetbrains/youtrack/agile/persistence/listener/SprintFieldValueListener;", "Ljetbrains/youtrack/agile/persistence/listener/AgileEntityListener;", "Ljetbrains/charisma/customfields/persistence/fields/XdField;", "Ljetbrains/charisma/customfields/persistence/fields/RemoveFieldHandler;", "()V", "entityType", "Lkotlinx/dnq/XdEntityType;", "getEntityType", "()Lkotlinx/dnq/XdEntityType;", "addedSync", "", "added", "getAffectedAgiles", "", "Ljetbrains/youtrack/agile/persistence/XdAgile;", "field", "getAffectedSprints", "Ljetbrains/youtrack/agile/persistence/XdSprint;", "oldFieldName", "", "bundle", "Ljetbrains/charisma/customfields/persistence/fields/XdFieldBundle;", "handleFieldRemove", "updatedSync", "old", "current", "isAffectedBy", "", "Companion", "youtrack-scrumboard"})
public class SprintFieldValueListener
implements AgileEntityListener<XdField>,
RemoveFieldHandler {
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public XdEntityType<XdField> getEntityType() {
        return (XdEntityType)XdField.Companion;
    }

    public void addedSync(@NotNull XdField added) {
        Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
        String valueName = added.getName();
        Iterable<XdAgile> $receiver$iv = this.getAffectedAgiles(added);
        Iterator<XdAgile> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            XdAgile element$iv;
            XdAgile it = element$iv = iterator2.next();
            boolean bl = false;
            if (it.findSprint(valueName) != null) continue;
            if (!XdSprintKt.isValidSprintName(valueName)) {
                String string = valueName + " is restricted name for sprint. Skipping sprint creation.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            SyncFieldUtilKt.newSprint(it, added);
        }
    }

    public void handleFieldRemove(@NotNull XdField field2, @NotNull XdFieldBundle<?> bundle) {
        Iterable<XdSprint> affectedSprints;
        Intrinsics.checkParameterIsNotNull((Object)field2, (String)"field");
        Intrinsics.checkParameterIsNotNull(bundle, (String)"bundle");
        Iterable<XdSprint> $receiver$iv = affectedSprints = this.getAffectedSprints(field2.getName(), bundle);
        Iterator<XdSprint> iterator2 = $receiver$iv.iterator();
        while (iterator2.hasNext()) {
            XdSprint element$iv;
            XdSprint it = element$iv = iterator2.next();
            boolean bl = false;
            if (SyncFieldUtilKt.hasUsages(it.getAgile(), field2.getName())) continue;
            it.delete();
        }
    }

    public void updatedSync(@NotNull XdField old, @NotNull XdField current) {
        XdSprint it;
        XdSprint element$iv;
        Iterator<XdSprint> iterator2;
        Iterable<XdSprint> $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        XdFieldBundle xdFieldBundle = current.getBundle();
        if (xdFieldBundle == null) {
            return;
        }
        XdFieldBundle bundle = xdFieldBundle;
        Iterable<XdSprint> affectedSprints = this.getAffectedSprints(old.getName(), bundle);
        String oldName = old.getName();
        String newName = current.getName();
        if (current instanceof XdProjectVersion) {
            if (!((XdProjectVersion)current).getArchived()) {
                $receiver$iv = affectedSprints;
                iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl = false;
                    it.setArchived(false);
                }
            } else {
                $receiver$iv = affectedSprints;
                iterator2 = $receiver$iv.iterator();
                while (iterator2.hasNext()) {
                    it = element$iv = iterator2.next();
                    boolean bl = false;
                    if (SyncFieldUtilKt.hasUsages(it.getAgile(), oldName)) continue;
                    it.setArchived(true);
                }
            }
        }
        if (Intrinsics.areEqual((Object)oldName, (Object)newName) ^ true && bundle.findElement(oldName) == null) {
            $receiver$iv = affectedSprints;
            iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                it = element$iv = iterator2.next();
                boolean bl = false;
                SyncFieldUtilKt.handleValueRename(it, oldName, newName, current);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<XdAgile> getAffectedAgiles(XdField field2) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        XdFieldBundle xdFieldBundle = field2.getBundle();
        if (xdFieldBundle == null) {
            return CollectionsKt.emptyList();
        }
        XdFieldBundle bundle = xdFieldBundle;
        Iterable iterable2 = $receiver$iv = HelpersKt.asIterable((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdAgile.Companion), (Function2)getAffectedAgiles.1.INSTANCE));
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            XdAgile it = (XdAgile)((Object)element$iv$iv);
            boolean bl = false;
            if (!this.isAffectedBy(it, (XdFieldBundle<? extends XdField>)bundle)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final Iterable<XdSprint> getAffectedSprints(String oldFieldName, XdFieldBundle<?> bundle) {
        return SequencesKt.asIterable((Sequence)SequencesKt.filter((Sequence)XdQueryKt.asSequence((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdSprint.Companion), (Function2)((Function2)new Function2<FilteringContext, XdSprint, XdSearchingNode>(oldFieldName){
            final /* synthetic */ String $oldFieldName;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdSprint it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                return $receiver.eq((Comparable)((Object)it.getName()), (Comparable)((Object)this.$oldFieldName));
            }
            {
                this.$oldFieldName = string;
                super(2);
            }
        }))), (Function1)((Function1)new Function1<XdSprint, Boolean>(this, bundle){
            final /* synthetic */ SprintFieldValueListener this$0;
            final /* synthetic */ XdFieldBundle $bundle;

            public final boolean invoke(@NotNull XdSprint sprint2) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)sprint2), (String)"sprint");
                return SprintFieldValueListener.access$isAffectedBy(this.this$0, sprint2.getAgile(), this.$bundle);
            }
            {
                this.this$0 = sprintFieldValueListener;
                this.$bundle = xdFieldBundle;
                super(1);
            }
        })));
    }

    private final boolean isAffectedBy(@NotNull XdAgile $receiver, XdFieldBundle<? extends XdField> bundle) {
        XdCustomFieldPrototype xdCustomFieldPrototype = $receiver.getSprintSyncField();
        if (xdCustomFieldPrototype == null) {
            return false;
        }
        XdCustomFieldPrototype sprintSyncFieldPrototype = xdCustomFieldPrototype;
        XdQuery projectsWithBundleInSyncField2 = XdFilteringQueryKt.mapDistinct((XdQuery)XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdBundleProjectCustomField.Companion), (Function2)((Function2)new Function2<FilteringContext, XdBundleProjectCustomField, XdSearchingNode>(bundle, sprintSyncFieldPrototype){
            final /* synthetic */ XdFieldBundle $bundle;
            final /* synthetic */ XdCustomFieldPrototype $sprintSyncFieldPrototype;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdBundleProjectCustomField pcf) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                Intrinsics.checkParameterIsNotNull((Object)pcf, (String)"pcf");
                return $receiver.eq((XdEntity)pcf.getBundle(), (XdEntity)this.$bundle).and($receiver.eq((XdEntity)pcf.getPrototype(), (XdEntity)this.$sprintSyncFieldPrototype));
            }
            {
                this.$bundle = xdFieldBundle;
                this.$sprintSyncFieldPrototype = xdCustomFieldPrototype;
                super(2);
            }
        })), (Function1)isAffectedBy.projectsWithBundleInSyncField.2.INSTANCE);
        return XdQueryKt.isNotEmpty((XdQuery)XdQueryKt.intersect((XdQuery)projectsWithBundleInSyncField2, (XdQuery)((XdQuery)$receiver.getProjects())));
    }

    @Override
    public void add() {
        AgileEntityListener.DefaultImpls.add(this);
    }

    @Override
    public void remove() {
        AgileEntityListener.DefaultImpls.remove(this);
    }

    public void addedAsync(@NotNull XdField added) {
        Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
        AgileEntityListener.DefaultImpls.addedAsync(this, (XdEntity)added);
    }

    public void addedSyncAfterConstraints(@NotNull XdField added) {
        Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
        AgileEntityListener.DefaultImpls.addedSyncAfterConstraints(this, (XdEntity)added);
    }

    public void addedSyncBeforeConstraints(@NotNull XdField added) {
        Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
        AgileEntityListener.DefaultImpls.addedSyncBeforeConstraints(this, (XdEntity)added);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
    public void addedSyncBeforeFlush(@NotNull XdField added) {
        Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
        AgileEntityListener.DefaultImpls.addedSyncBeforeFlush(this, (XdEntity)added);
    }

    public void removedAsync(@NotNull XdField removed) {
        Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
        AgileEntityListener.DefaultImpls.removedAsync(this, (XdEntity)removed);
    }

    public void removedSync(@NotNull XdField removed) {
        Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
        AgileEntityListener.DefaultImpls.removedSync(this, (XdEntity)removed);
    }

    public void removedSyncAfterConstraints(@NotNull XdField removed) {
        Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
        AgileEntityListener.DefaultImpls.removedSyncAfterConstraints(this, (XdEntity)removed);
    }

    public void removedSyncBeforeConstraints(@NotNull XdField removed) {
        Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
        AgileEntityListener.DefaultImpls.removedSyncBeforeConstraints(this, (XdEntity)removed);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
    public void removedSyncBeforeFlush(@NotNull XdField added) {
        Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
        AgileEntityListener.DefaultImpls.removedSyncBeforeFlush(this, (XdEntity)added);
    }

    public void updatedAsync(@NotNull XdField old, @NotNull XdField current) {
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        AgileEntityListener.DefaultImpls.updatedAsync(this, (XdEntity)old, (XdEntity)current);
    }

    public void updatedSyncAfterConstraints(@NotNull XdField old, @NotNull XdField current) {
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        AgileEntityListener.DefaultImpls.updatedSyncAfterConstraints(this, (XdEntity)old, (XdEntity)current);
    }

    public void updatedSyncBeforeConstraints(@NotNull XdField old, @NotNull XdField current) {
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        AgileEntityListener.DefaultImpls.updatedSyncBeforeConstraints(this, (XdEntity)old, (XdEntity)current);
    }

    @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
    public void updatedSyncBeforeFlush(@NotNull XdField old, @NotNull XdField current) {
        Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
        Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
        AgileEntityListener.DefaultImpls.updatedSyncBeforeFlush(this, (XdEntity)old, (XdEntity)current);
    }

    public static final /* synthetic */ boolean access$isAffectedBy(SprintFieldValueListener $this, XdAgile $receiver, XdFieldBundle bundle) {
        return $this.isAffectedBy($receiver, (XdFieldBundle<? extends XdField>)bundle);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/youtrack/agile/persistence/listener/SprintFieldValueListener$Companion;", "Lmu/KLogging;", "()V", "youtrack-scrumboard"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

