/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.agile.sprint.timetracking;

import com.fasterxml.jackson.annotation.JsonIgnore;
import jetbrains.gap.resource.Entity;
import jetbrains.youtrack.agile.sprint.timetracking.TimeTrackingDataAccessor;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006\u00a2\u0006\u0002\u0010\u0007J%\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00028\u00002\u0006\u0010\u0019\u001a\u00028\u00002\u0006\u0010\b\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001c\u001a\u00020\u001d2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030\u0000J\u000e\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\"R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u00068\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\b\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u000e\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u00028\u0000X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\u001a\u0010\n\"\u0004\b\u001b\u0010\f\u00a8\u0006#"}, d2={"Ljetbrains/youtrack/agile/sprint/timetracking/TimeTrackingData;", "T", "", "", "Ljetbrains/gap/resource/Entity;", "dataAccessor", "Ljetbrains/youtrack/agile/sprint/timetracking/TimeTrackingDataAccessor;", "(Ljetbrains/youtrack/agile/sprint/timetracking/TimeTrackingDataAccessor;)V", "effectiveEstimation", "getEffectiveEstimation", "()Ljava/lang/Number;", "setEffectiveEstimation", "(Ljava/lang/Number;)V", "Ljava/lang/Number;", "estimation", "getEstimation", "setEstimation", "hasExplicitSpentTime", "", "getHasExplicitSpentTime", "()Z", "id", "", "getId", "()Ljava/lang/String;", "spentTime", "getSpentTime", "setSpentTime", "add", "", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "data", "addIssue", "issue", "Ljetbrains/youtrack/persistent/XdIssue;", "youtrack-scrumboard"})
public class TimeTrackingData<T extends Number>
extends Entity {
    @NotNull
    private T estimation;
    @NotNull
    private T spentTime;
    @NotNull
    private T effectiveEstimation;
    private final boolean hasExplicitSpentTime;
    @JsonIgnore
    private final TimeTrackingDataAccessor<T> dataAccessor;

    @NotNull
    public String getId() {
        return "timeTracking";
    }

    @NotNull
    public final T getEstimation() {
        return this.estimation;
    }

    public final void setEstimation(@NotNull T t) {
        Intrinsics.checkParameterIsNotNull(t, (String)"<set-?>");
        this.estimation = t;
    }

    @NotNull
    public final T getSpentTime() {
        return this.spentTime;
    }

    public final void setSpentTime(@NotNull T t) {
        Intrinsics.checkParameterIsNotNull(t, (String)"<set-?>");
        this.spentTime = t;
    }

    @NotNull
    public final T getEffectiveEstimation() {
        return this.effectiveEstimation;
    }

    public final void setEffectiveEstimation(@NotNull T t) {
        Intrinsics.checkParameterIsNotNull(t, (String)"<set-?>");
        this.effectiveEstimation = t;
    }

    public final boolean getHasExplicitSpentTime() {
        return this.hasExplicitSpentTime;
    }

    public final void addIssue(@NotNull XdIssue issue2) {
        Intrinsics.checkParameterIsNotNull((Object)issue2, (String)"issue");
        T estimation = this.dataAccessor.getEstimation(issue2);
        T spentTime = this.dataAccessor.getSpentTime(issue2);
        T effectiveEstimation = !issue2.isResolved() ? (Number)((Object)ComparisonsKt.maxOf((Comparable)((Comparable)estimation), (Comparable)((Comparable)spentTime))) : spentTime;
        this.add(estimation, spentTime, effectiveEstimation);
    }

    public final void add(@NotNull TimeTrackingData<?> data) {
        Intrinsics.checkParameterIsNotNull(data, (String)"data");
        T t = data.estimation;
        if (t == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        T t2 = data.spentTime;
        if (t2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        T t3 = data.effectiveEstimation;
        if (t3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type T");
        }
        this.add(t, t2, t3);
    }

    private final void add(T estimation, T spentTime, T effectiveEstimation) {
        this.estimation = this.dataAccessor.sumValues(this.estimation, estimation);
        this.spentTime = this.dataAccessor.sumValues(this.spentTime, spentTime);
        this.effectiveEstimation = this.dataAccessor.sumValues(this.effectiveEstimation, effectiveEstimation);
    }

    public TimeTrackingData(@NotNull TimeTrackingDataAccessor<T> dataAccessor) {
        Intrinsics.checkParameterIsNotNull(dataAccessor, (String)"dataAccessor");
        this.dataAccessor = dataAccessor;
        this.estimation = this.dataAccessor.getZero();
        this.spentTime = this.dataAccessor.getZero();
        this.effectiveEstimation = this.dataAccessor.getZero();
        this.hasExplicitSpentTime = this.dataAccessor.getHasExplicitSpentTime();
    }
}

