/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.backend.config;

import com.jetbrains.bundle.api.internal.auth.AuthService;
import com.jetbrains.bundle.api.internal.backend.BundleFacade;
import com.jetbrains.bundle.api.internal.backend.BundleFacadeHelper;
import com.jetbrains.bundle.api.internal.services.ServicesInformationHelper;
import com.jetbrains.bundle.api.internal.services.ServicesInformationProvider;
import com.jetbrains.bundle.backend.rest.AuthInterceptor;
import com.jetbrains.bundle.util.auth.Authenticator;
import com.jetbrains.bundle.util.auth.impl.AuthenticatorCountingAttemptsImpl;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.WebContentInterceptor;

@Configuration
@EnableWebMvc
public class AppConfig
implements WebMvcConfigurer {
    public void addInterceptors(InterceptorRegistry registry) {
        WebContentInterceptor interceptor = new WebContentInterceptor();
        interceptor.setCacheSeconds(0);
        interceptor.setCacheControl(CacheControl.noStore());
        registry.addInterceptor((HandlerInterceptor)interceptor);
        AuthInterceptor authInterceptor = new AuthInterceptor(this.getAuthenticator());
        registry.addInterceptor((HandlerInterceptor)authInterceptor);
    }

    @Bean
    public Authenticator getAuthenticator() {
        return new AuthenticatorCountingAttemptsImpl((AuthService)this.getBundleFacade());
    }

    @Bean
    public ServicesInformationProvider getServicesInformationProvider() {
        return ServicesInformationHelper.getServicesInformationProvider();
    }

    @Bean
    public BundleFacade getBundleFacade() {
        return BundleFacadeHelper.getBundleFacade();
    }
}

