/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.backend.rest;

import com.jetbrains.bundle.api.internal.services.ServicesInformationProvider;
import com.jetbrains.bundle.api.internal.services.model.ProductState;
import com.jetbrains.bundle.backend.model.ProductStateInfo;
import com.jetbrains.bundle.util.BundleUtil;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/state"}, produces={"application/json"})
public class ProductStateController {
    @Autowired
    ServicesInformationProvider myServicesInformationProvider;

    @RequestMapping(method={RequestMethod.GET})
    public ProductStateInfo getProductStateInfo(@RequestParam(value="fields", required=false) String fields, HttpServletRequest request) {
        ProductState productState = this.myServicesInformationProvider.getProductState();
        if (productState == null) {
            return null;
        }
        return new ProductStateInfo(this.myServicesInformationProvider.isBundleStarting(), productState.isWizard(), productState.getProductName(), productState.getProductPresentationName(), BundleUtil.resolveServiceUrlForClient((HttpServletRequest)request, (String)productState.getDefaultServiceUrl()), productState.getRunId());
    }

    @RequestMapping(value={"/started"}, method={RequestMethod.GET})
    public ResponseEntity<String> getProductStarted() {
        if (this.myServicesInformationProvider.isBundleStarting()) {
            return new ResponseEntity((Object)"STARTING", HttpStatus.SERVICE_UNAVAILABLE);
        }
        return new ResponseEntity((Object)"OK", HttpStatus.OK);
    }
}

