/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.configs.LauncherCmdConfig;
import com.jetbrains.launcher.configs.LauncherConfigValidator;
import com.jetbrains.launcher.configs.LauncherJavaConfig;
import com.jetbrains.launcher.util.CollectionUtil;
import com.jetbrains.launcher.util.LauncherUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LauncherConfigAppFilesAwareValidator
implements LauncherConfigValidator {
    @NotNull
    public static final String APP_CONFIGURATOR_CLASS_NAME = "com.jetbrains.launcher.ep.AppConfigurator";
    @NotNull
    public static final String APP_STARTER_CLASS_NAME = "com.jetbrains.launcher.ep.AppStarter";
    @NotNull
    public static final String SIMPLE_APPLICATION_WRAPPER_CLASS_NAME = "com.jetbrains.launcher.wrappers.SimpleApplication";
    @NotNull
    private final AppFilesEx myAppFiles;

    public LauncherConfigAppFilesAwareValidator(@NotNull AppFilesEx appFiles) {
        if (appFiles == null) {
            LauncherConfigAppFilesAwareValidator.$$$reportNull$$$0(0);
        }
        this.myAppFiles = appFiles;
    }

    public void validateCmdConfig(@NotNull LauncherCmdConfig launcherCmdConfig) {
        if (launcherCmdConfig == null) {
            LauncherConfigAppFilesAwareValidator.$$$reportNull$$$0(1);
        }
    }

    public void validateJavaConfig(@NotNull LauncherJavaConfig launcherJavaConfig) throws InitException {
        if (launcherJavaConfig == null) {
            LauncherConfigAppFilesAwareValidator.$$$reportNull$$$0(2);
        }
        this.checkAppWrapperClass("com.jetbrains.launcher.ep.Bootstrap");
        this.checkAppWrapperClass(APP_CONFIGURATOR_CLASS_NAME);
        this.checkAppWrapperClass(APP_STARTER_CLASS_NAME);
        String appWrapperClassName = launcherJavaConfig.getAppWrapperClassName();
        if (appWrapperClassName.equals(SIMPLE_APPLICATION_WRAPPER_CLASS_NAME)) {
            this.checkAppWrapperClass(appWrapperClassName);
            String mainClassName = (String)CollectionUtil.getOrNull((List)launcherJavaConfig.getAppWrapperArgs(), (int)0);
            if (mainClassName == null) {
                throw new InitException("Main class is not specified for com.jetbrains.launcher.wrappers.SimpleApplication");
            }
            this.checkApplicationClass(mainClassName);
        } else {
            this.checkApplicationClass(appWrapperClassName);
        }
    }

    private void checkApplicationClass(@NotNull String className) throws InitException {
        if (className == null) {
            LauncherConfigAppFilesAwareValidator.$$$reportNull$$$0(3);
        }
        LauncherConfigAppFilesAwareValidator.doCheckClass(this.myAppFiles.getAppLibFolder(), className);
    }

    private void checkAppWrapperClass(@NotNull String className) throws InitException {
        if (className == null) {
            LauncherConfigAppFilesAwareValidator.$$$reportNull$$$0(4);
        }
        LauncherConfigAppFilesAwareValidator.doCheckClass(this.myAppFiles.getAppWrapperLibFolder(), className);
    }

    private static void doCheckClass(@NotNull File libFolder, @NotNull String className) throws InitException {
        if (libFolder == null) {
            LauncherConfigAppFilesAwareValidator.$$$reportNull$$$0(5);
        }
        if (className == null) {
            LauncherConfigAppFilesAwareValidator.$$$reportNull$$$0(6);
        }
        if (!LauncherUtil.hasClassInJars(libFolder, className)) {
            throw new InitException("Class \"" + className + "\" is not found at path: " + libFolder.getAbsolutePath());
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherCmdConfig";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherJavaConfig";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libFolder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/launcher/LauncherConfigAppFilesAwareValidator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validateCmdConfig";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "validateJavaConfig";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkApplicationClass";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAppWrapperClass";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheckClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

