/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppConfigFiles;
import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.AppFixedFiles;
import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.InitAction;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherConfigFilesAwareContext;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherContextFactory;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.LauncherExtension;
import com.jetbrains.launcher.configs.AppConfig;
import com.jetbrains.launcher.configs.AppConfigImpl;
import com.jetbrains.launcher.configs.properties.AppConfigProperty;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.ep.commands.Run;
import com.jetbrains.launcher.lock.AppLock;
import com.jetbrains.launcher.lock.AppLockFactory;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.lock.CannotAcquireAppLockException;
import com.jetbrains.launcher.lock.LauncherAwareAppLock;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.util.ConfiguringArgumentsParser;
import com.jetbrains.launcher.util.ExceptionUtil;
import com.jetbrains.launcher.util.FileUtil;
import com.jetbrains.launcher.util.LauncherUtil;
import com.jetbrains.launcher.util.PropertiesUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import com.jetbrains.launcher.util.StringUtil;
import com.jetbrains.launcher.util.java.InvalidJvmOptionException;
import com.jetbrains.launcher.util.java.JvmOptionsMerger;
import com.jetbrains.launcher.util.java.JvmOptionsUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Configure
extends BaseCommand {
    @NotNull
    public static final String NAME = "configure";
    @NotNull
    private final Logger LOG = Logger.getLogger(Configure.class);
    @Nullable
    private final String myParentCommandName;

    public Configure() {
        this(null);
    }

    public Configure(@Nullable String parentCommandName) {
        this.myParentCommandName = parentCommandName;
    }

    @NotNull
    public String getName() {
        if (NAME == null) {
            Configure.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getFullName() {
        String string = this.myParentCommandName == null ? this.getName() : this.myParentCommandName + " " + this.getName();
        if (string == null) {
            Configure.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("b" == null) {
            Configure.$$$reportNull$$$0(2);
        }
        return "b";
    }

    @Override
    @NotNull
    protected File getLauncherLogsFolder(@NotNull Arguments args, @NotNull AppConfig appConfig, @NotNull AppFiles appFiles) {
        block7: {
            File file;
            if (args == null) {
                Configure.$$$reportNull$$$0(3);
            }
            if (appConfig == null) {
                Configure.$$$reportNull$$$0(4);
            }
            if (appFiles == null) {
                Configure.$$$reportNull$$$0(5);
            }
            try {
                File logsDir = Configure.getNewLauncherLogsDir(appConfig, appFiles, Configure.getArgumentsParser(args).getProperties());
                if (logsDir == null) break block7;
                file = logsDir;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            if (file == null) {
                Configure.$$$reportNull$$$0(6);
            }
            return file;
        }
        File file = super.getLauncherLogsFolder(args, appConfig, appFiles);
        if (file == null) {
            Configure.$$$reportNull$$$0(7);
        }
        return file;
    }

    @Nullable
    private static File getNewLauncherLogsDir(@NotNull AppConfig appConfig, @NotNull AppFiles appFiles, @NotNull Map<String, String> properties) {
        if (appConfig == null) {
            Configure.$$$reportNull$$$0(8);
        }
        if (appFiles == null) {
            Configure.$$$reportNull$$$0(9);
        }
        if (properties == null) {
            Configure.$$$reportNull$$$0(10);
        }
        String logsDir = properties.get("logs-dir");
        String launcherLogsDir = properties.get("launcher.logs-dir");
        return logsDir == null && launcherLogsDir == null ? null : appFiles.resolvePath(appFiles.resolvePath(StringUtil.notNullize((String)logsDir, (String)appConfig.getAppLogsDirPath(), (String)"logs")), StringUtil.notNullize((String)launcherLogsDir, (String)appConfig.getLauncherLogsDirPath(), (String)"."));
    }

    @Override
    @NotNull
    protected LoggerMode getLoggerMode(@NotNull Arguments args) {
        if (args == null) {
            Configure.$$$reportNull$$$0(11);
        }
        LoggerMode loggerMode = LoggerMode.LAUNCHER;
        if (loggerMode == null) {
            Configure.$$$reportNull$$$0(12);
        }
        return loggerMode;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(final @NotNull LauncherContextEx context) throws InitException {
        LauncherExitCode launcherExitCode;
        File newLauncherLogsFolder;
        Arguments args;
        if (context == null) {
            Configure.$$$reportNull$$$0(13);
        }
        if ((args = context.getArguments()).getJvmOptions1().isEmpty() && args.getApplicationArguments().isEmpty()) {
            throw new IllegalArgumentException();
        }
        AppFilesEx appFiles = context.getAppFiles();
        final ConfiguringArgumentsParser argsParser = Configure.getArgumentsParser(args);
        try {
            newLauncherLogsFolder = Configure.getNewLauncherLogsDir(context.getAppConfig(), (AppFiles)appFiles, argsParser.getProperties());
        }
        catch (IOException e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)"Failed to configure JetLauncher", (Throwable)e);
            LauncherExitCode launcherExitCode2 = LauncherExitCode.ERROR;
            if (launcherExitCode2 == null) {
                Configure.$$$reportNull$$$0(14);
            }
            return launcherExitCode2;
        }
        File oldLauncherLogsFolder = appFiles.getLauncherLogsFolder();
        AppLock appLock = Configure.createConfigureAppLock(args, (AppFixedFiles)appFiles, oldLauncherLogsFolder, newLauncherLogsFolder);
        try {
            launcherExitCode = AppLockFactory.withLock(appLock, AppState.CONFIGURE, new InitAction(){

                @Override
                @NotNull
                public LauncherExitCode run() throws InitException {
                    LauncherExitCode launcherExitCode = Configure.this.runUnderLock(context, argsParser, newLauncherLogsFolder);
                    if (launcherExitCode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return launcherExitCode;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/commands/Configure$1", "run"));
                }
            });
        }
        catch (CannotAcquireAppLockException e) {
            if (Configure.isNewLauncherLogsDirectory(oldLauncherLogsFolder, newLauncherLogsFolder) && Configure.createAppLock((AppFixedFiles)appFiles, newLauncherLogsFolder).isLocked()) {
                this.LOG.error((Object)("Failed to set logs directory to \"" + newLauncherLogsFolder.getAbsolutePath() + "\": some launcher process is now running using that directory"));
            } else {
                this.LOG.error((Object)context.getIllegalAppStateErrorText(AppState.CONFIGURE));
            }
            LauncherExitCode launcherExitCode3 = LauncherExitCode.ILLEGAL_STATE;
            if (launcherExitCode3 == null) {
                Configure.$$$reportNull$$$0(16);
            }
            return launcherExitCode3;
        }
        if (launcherExitCode == null) {
            Configure.$$$reportNull$$$0(15);
        }
        return launcherExitCode;
    }

    private static AppLock createConfigureAppLock(@NotNull Arguments args, @NotNull AppFixedFiles appFixedFiles, @NotNull File oldLauncherLogsFolder, @Nullable File newLauncherLogsFolder) {
        if (args == null) {
            Configure.$$$reportNull$$$0(17);
        }
        if (appFixedFiles == null) {
            Configure.$$$reportNull$$$0(18);
        }
        if (oldLauncherLogsFolder == null) {
            Configure.$$$reportNull$$$0(19);
        }
        if (args.containsLauncherOption()) {
            return AppLockFactory.createNoLock();
        }
        if (!Configure.isNewLauncherLogsDirectory(oldLauncherLogsFolder, newLauncherLogsFolder)) {
            return Configure.createAppLock(appFixedFiles, oldLauncherLogsFolder);
        }
        if (!oldLauncherLogsFolder.isDirectory()) {
            return Configure.createAppLock(appFixedFiles, newLauncherLogsFolder);
        }
        return AppLockFactory.createCompositeLock(Configure.createAppLock(appFixedFiles, oldLauncherLogsFolder), Configure.createAppLock(appFixedFiles, newLauncherLogsFolder));
    }

    @Contract(value="_, null -> false")
    private static boolean isNewLauncherLogsDirectory(@NotNull File oldLauncherLogsFolder, @Nullable File newLauncherLogsFolder) {
        if (oldLauncherLogsFolder == null) {
            Configure.$$$reportNull$$$0(20);
        }
        return newLauncherLogsFolder != null && !newLauncherLogsFolder.equals(oldLauncherLogsFolder);
    }

    @NotNull
    private static AppLock createAppLock(@NotNull AppFixedFiles appFixedFiles, @NotNull File launcherLogsFolder) {
        if (appFixedFiles == null) {
            Configure.$$$reportNull$$$0(21);
        }
        if (launcherLogsFolder == null) {
            Configure.$$$reportNull$$$0(22);
        }
        LauncherAwareAppLock launcherAwareAppLock = AppLockFactory.createLock(launcherLogsFolder, appFixedFiles);
        if (launcherAwareAppLock == null) {
            Configure.$$$reportNull$$$0(23);
        }
        return launcherAwareAppLock;
    }

    @NotNull
    private LauncherExitCode runUnderLock(@NotNull LauncherContextEx context, @NotNull ConfiguringArgumentsParser argsParser, @Nullable File newLauncherLogsFolder) throws InitException {
        if (context == null) {
            Configure.$$$reportNull$$$0(24);
        }
        if (argsParser == null) {
            Configure.$$$reportNull$$$0(25);
        }
        Run.prepareConfigDistFiles(context, this.LOG);
        if (!this.configureLauncher(context, argsParser, newLauncherLogsFolder)) {
            LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
            if (launcherExitCode == null) {
                Configure.$$$reportNull$$$0(26);
            }
            return launcherExitCode;
        }
        LauncherExitCode launcherExitCode = this.doConfigure(LauncherContextFactory.createContext((LauncherConfigFilesAwareContext)context));
        if (launcherExitCode == null) {
            Configure.$$$reportNull$$$0(27);
        }
        return launcherExitCode;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private LauncherExitCode doConfigure(@NotNull LauncherContextEx context) throws InitException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean configureLauncher(@NotNull LauncherContext context, @NotNull ConfiguringArgumentsParser argsParser, @Nullable File newLauncherLogsFolder) {
        if (context == null) {
            Configure.$$$reportNull$$$0(35);
        }
        if (argsParser == null) {
            Configure.$$$reportNull$$$0(36);
        }
        Arguments args = context.getArguments();
        try {
            List<String> jvmOptions;
            HashMap<String, String> newLauncherProperties = new HashMap<String, String>();
            boolean isLauncherOnly = args.containsLauncherOption();
            Map<String, AppConfigProperty> allConfigProperties = AppConfigImpl.getAllProperties();
            for (Map.Entry entry : argsParser.getProperties().entrySet()) {
                String propertyName = (String)entry.getKey();
                AppConfigProperty configProperty = allConfigProperties.get(propertyName);
                if (configProperty != null) {
                    configProperty.checkIsApplicable(args);
                    newLauncherProperties.put(propertyName, configProperty.toRawValue(context, (String)entry.getValue()));
                    continue;
                }
                if (!isLauncherOnly) continue;
                throw new InitException("Unknown JetLauncher property: " + propertyName);
            }
            AppFilesEx appFiles = context.getAppFiles();
            if (!newLauncherProperties.isEmpty()) {
                this.copyRuntimeFilesIfNeeded(context, newLauncherLogsFolder);
                File launchConfigFile = appFiles.getAppConfigFile(".launch.config");
                if (!launchConfigFile.isFile()) {
                    File launchConfigDistFile = appFiles.getAppConfigFile(".launch.config.dist");
                    LauncherUtil.copy(launchConfigDistFile, launchConfigFile, null);
                }
                PropertiesUtil.fixPropertyValues((File)launchConfigFile, newLauncherProperties);
            }
            if (args.isJavaApplication() && !(jvmOptions = Configure.mergeJvmOptions(args.getJvmOptions1(), argsParser.getJvmOptions())).isEmpty()) {
                File jvmOptionsFile = appFiles.getAppConfigFile(".jvmoptions");
                if (!jvmOptionsFile.isFile()) {
                    File jvmOptionsDistFile = appFiles.getAppConfigFile(".jvmoptions.dist");
                    LauncherUtil.copy(jvmOptionsDistFile, jvmOptionsFile, null);
                }
                JvmOptionsUtil.fixJvmOptions(jvmOptionsFile, jvmOptions);
            }
            return true;
        }
        catch (Exception e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)"Failed to configure JetLauncher", (Throwable)e);
            return false;
        }
    }

    private void copyRuntimeFilesIfNeeded(@NotNull LauncherContext context, @Nullable File newLauncherLogsFolder) throws IOException {
        if (context == null) {
            Configure.$$$reportNull$$$0(37);
        }
        if (newLauncherLogsFolder == null) {
            return;
        }
        AppFilesEx oldAppFiles = context.getAppFiles();
        if (newLauncherLogsFolder.equals(oldAppFiles.getLauncherLogsFolder())) {
            return;
        }
        for (File oldRuntimeFile : RuntimeUtil.getAllAppRuntimeFiles((AppFiles)oldAppFiles)) {
            LauncherUtil.copy(oldRuntimeFile, new File(newLauncherLogsFolder, oldRuntimeFile.getName()), null);
        }
    }

    @NotNull
    private static ConfiguringArgumentsParser getArgumentsParser(@NotNull Arguments args) {
        if (args == null) {
            Configure.$$$reportNull$$$0(38);
        }
        ConfiguringArgumentsParser configuringArgumentsParser = new ConfiguringArgumentsParser(args.getApplicationArguments(), args.getPathResolver(), !args.containsLauncherOption(), args.isJavaApplication());
        if (configuringArgumentsParser == null) {
            Configure.$$$reportNull$$$0(39);
        }
        return configuringArgumentsParser;
    }

    @NotNull
    private static List<String> mergeJvmOptions(@NotNull List<String> argsJvmOptions, @NotNull List<String> appJvmOptions) throws InvalidJvmOptionException {
        if (argsJvmOptions == null) {
            Configure.$$$reportNull$$$0(40);
        }
        if (appJvmOptions == null) {
            Configure.$$$reportNull$$$0(41);
        }
        JvmOptionsMerger jvmOptionsMerger = new JvmOptionsMerger(null);
        jvmOptionsMerger.addJvmOptions(argsJvmOptions);
        jvmOptionsMerger.addJvmOptions(appJvmOptions);
        List<String> list = jvmOptionsMerger.getRawJvmOptions();
        if (list == null) {
            Configure.$$$reportNull$$$0(42);
        }
        return list;
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Configure.$$$reportNull$$$0(43);
        }
        if (context == null) {
            Configure.$$$reportNull$$$0(44);
        }
        if (this.myParentCommandName == null) {
            printer.print(this.getFullName(), "configures " + context.getAppConfig().getAppName().getName() + ", " + this.getComplexCommandUsageText());
        } else {
            printer.print(this.getFullName(), "same as \"configure\" command");
        }
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Configure.$$$reportNull$$$0(45);
        }
        if (context == null) {
            Configure.$$$reportNull$$$0(46);
        }
        Arguments args = context.getArguments();
        boolean isJavaApp = args.isJavaApplication();
        String name = context.getAppConfig().getAppName().getName();
        printer.print(this.getFullName() + " <argument1> <argument2> ...", "configures " + name + " properties" + (isJavaApp ? " and JVM options" : ""));
        ConsoleLogger.error((String)"Arguments can be the following:");
        ConsoleLogger.error();
        printer.print("--<property name>=<property value>", "changes the value of the specified property");
        printer.print("--<property name> <property value>", "changes the value of the specified property");
        printer.print("-f <properties file path>", "reads the properties from the specified file and applies its values");
        if (isJavaApp) {
            AppFilesEx appFiles = context.getAppFiles();
            String jvmOptionsFileRelPath = FileUtil.getRelativePath((File)appFiles.getAppHome(), (File)appFiles.getAppConfigFile(".jvmoptions"));
            printer.print("-J<JVM option>", "adds the specified JVM option to the " + name + " JVM options list, see additional comments in the \"" + jvmOptionsFileRelPath + "\" file");
            Run.printAdHocJvmOptionsInfo(true);
        }
        ConsoleLogger.error((String)("Use \"--launcher\" option to configure the launcher only and not pass the specified properties to " + name));
        ConsoleLogger.error();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/Configure";
                break;
            }
            case 3: 
            case 11: 
            case 17: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appConfig";
                break;
            }
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 13: 
            case 24: 
            case 28: 
            case 35: 
            case 37: 
            case 44: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFixedFiles";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldLauncherLogsFolder";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "launcherLogsFolder";
                break;
            }
            case 25: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argsParser";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argsJvmOptions";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appJvmOptions";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/Configure";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherLogsFolder";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerMode";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppLock";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "runUnderLock";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "doConfigure";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentsParser";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "mergeJvmOptions";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLauncherLogsFolder";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNewLauncherLogsDir";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerMode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createConfigureAppLock";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isNewLauncherLogsDirectory";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createAppLock";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "runUnderLock";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doConfigure";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "configureLauncher";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "copyRuntimeFilesIfNeeded";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentsParser";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "mergeJvmOptions";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 46: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface ServiceConfig
    extends LauncherExtension {
        @NotNull
        public File getServiceConfigFile(@NotNull AppConfigFiles var1);

        @Nullable
        public LauncherExitCode configureService(@NotNull LauncherContextEx var1) throws InitException;
    }
}

