/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.Arguments;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.configs.AppJavaInfo;
import com.jetbrains.launcher.configs.JvmOptions;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseListSubCommand;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.run.JavaAgent;
import com.jetbrains.launcher.util.CmdUtil;
import com.jetbrains.launcher.util.ExceptionUtil;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class ListJvmOptions
extends BaseListSubCommand {
    @NotNull
    private static final String NAME = "jvm-options";
    @NotNull
    private final Logger LOG = Logger.getLogger(ListJvmOptions.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            ListJvmOptions.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    public boolean isAvailable(@NotNull Arguments args) {
        if (args == null) {
            ListJvmOptions.$$$reportNull$$$0(1);
        }
        return args.isJavaApplication();
    }

    @Override
    protected boolean readsFromOrWritesToLogsFolder() {
        return false;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) {
        LauncherExitCode launcherExitCode;
        if (context == null) {
            ListJvmOptions.$$$reportNull$$$0(2);
        }
        try {
            Arguments args = context.getArguments();
            JavaAgent agentFacade = (JavaAgent)context.createAgentFacade();
            AppJavaInfo appJavaInfo = agentFacade.determineAppJava(args);
            JvmOptions jvmOptions = agentFacade.readAppJvmOptions(args, appJavaInfo, true);
            for (String string : jvmOptions.getJvmOptions()) {
                ConsoleLogger.system((String)string);
            }
            for (Map.Entry entry : jvmOptions.getEnvSystemProperties().entrySet()) {
                ConsoleLogger.system((String)CmdUtil.createSystemPropertyJvmOption((Map.Entry)entry));
            }
            launcherExitCode = LauncherExitCode.OK;
        }
        catch (Exception e) {
            ExceptionUtil.logError((Logger)this.LOG, (String)("Failed to list " + context.getAppConfig().getAppName().getName() + " JVM options"), (Throwable)e);
            LauncherExitCode launcherExitCode2 = LauncherExitCode.ERROR;
            if (launcherExitCode2 == null) {
                ListJvmOptions.$$$reportNull$$$0(4);
            }
            return launcherExitCode2;
        }
        if (launcherExitCode == null) {
            ListJvmOptions.$$$reportNull$$$0(3);
        }
        return launcherExitCode;
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            ListJvmOptions.$$$reportNull$$$0(5);
        }
        if (context == null) {
            ListJvmOptions.$$$reportNull$$$0(6);
        }
        printer.print(this.getFullName(), "resolves and lists all " + context.getAppConfig().getAppName().getName() + " JVM options (one option per line)");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/ListJvmOptions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/ListJvmOptions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

