/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep.commands;

import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.InitAction;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.LauncherContext;
import com.jetbrains.launcher.LauncherContextEx;
import com.jetbrains.launcher.LauncherExitCode;
import com.jetbrains.launcher.ep.Command;
import com.jetbrains.launcher.ep.commands.BaseCommand;
import com.jetbrains.launcher.ep.commands.BaseRestartCommand;
import com.jetbrains.launcher.ep.commands.BaseSoftModeSupportingCommand;
import com.jetbrains.launcher.ep.commands.Run;
import com.jetbrains.launcher.ep.commands.Start;
import com.jetbrains.launcher.ep.commands.Stop;
import com.jetbrains.launcher.lock.AppState;
import com.jetbrains.launcher.log.ConsoleLogger;
import com.jetbrains.launcher.run.AgentRestartFacade;
import com.jetbrains.launcher.run.AgentStartFacade;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class Restart
extends BaseRestartCommand {
    @NotNull
    private static final String NAME = "restart";
    @NotNull
    private final Logger LOG = Logger.getLogger(Restart.class);

    @NotNull
    public String getName() {
        if (NAME == null) {
            Restart.$$$reportNull$$$0(0);
        }
        return NAME;
    }

    @Override
    @NotNull
    public String getOrderId() {
        if ("g" == null) {
            Restart.$$$reportNull$$$0(1);
        }
        return "g";
    }

    @Override
    @NotNull
    protected String getMessage(@NotNull AppName appName) {
        if (appName == null) {
            Restart.$$$reportNull$$$0(2);
        }
        String string = "Restarting " + appName.getName() + "...";
        if (string == null) {
            Restart.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    @NotNull
    protected BaseCommand getStartCommand() {
        Start start = new Start();
        if (start == null) {
            Restart.$$$reportNull$$$0(4);
        }
        return start;
    }

    @Override
    @NotNull
    protected LauncherExitCode doRun(@NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            Restart.$$$reportNull$$$0(5);
        }
        if (context.getArguments().containsAppOption()) {
            LauncherExitCode launcherExitCode = this.doRestartApp(context);
            if (launcherExitCode == null) {
                Restart.$$$reportNull$$$0(6);
            }
            return launcherExitCode;
        }
        LauncherExitCode launcherExitCode = super.doRun(context);
        if (launcherExitCode == null) {
            Restart.$$$reportNull$$$0(7);
        }
        return launcherExitCode;
    }

    @NotNull
    private LauncherExitCode doRestartApp(final @NotNull LauncherContextEx context) throws InitException {
        if (context == null) {
            Restart.$$$reportNull$$$0(8);
        }
        final AppName appName = context.getAppConfig().getAppName();
        AppState appState = context.getAppState();
        if (appState == null || !appState.isRunState()) {
            this.LOG.error((Object)(appName.getCapitalizedName() + " is not running"));
            LauncherExitCode launcherExitCode = LauncherExitCode.ILLEGAL_STATE;
            if (launcherExitCode == null) {
                Restart.$$$reportNull$$$0(9);
            }
            return launcherExitCode;
        }
        final AgentStartFacade agentFacade = context.createAgentFacade();
        final AgentRestartFacade restartFacade = agentFacade.getRestartFacade();
        if (restartFacade == null) {
            this.LOG.error((Object)"Option \"--app\" is available only for Java applications");
            LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
            if (launcherExitCode == null) {
                Restart.$$$reportNull$$$0(10);
            }
            return launcherExitCode;
        }
        LauncherExitCode stopCode = Stop.attachAndRun(agentFacade, appName, this.LOG, new InitAction(){

            @Override
            @NotNull
            public LauncherExitCode run() throws InitException {
                if (restartFacade.requestRestart(BaseSoftModeSupportingCommand.isSoft(context.getArguments()))) {
                    Restart.this.LOG.info((Object)(appName.getCapitalizedName() + " has shut down"));
                    LauncherExitCode launcherExitCode = LauncherExitCode.OK;
                    if (launcherExitCode == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return launcherExitCode;
                }
                Restart.this.LOG.warn((Object)(appName.getCapitalizedName() + " has failed to shut down"));
                Start.dumpThreadsIfPossible(agentFacade, Restart.this.LOG);
                Restart.this.LOG.warn((Object)("Trying to kill " + appName.getName() + "..."));
                if (restartFacade.killForRestart()) {
                    Restart.this.LOG.info((Object)(appName.getCapitalizedName() + " has been killed"));
                    LauncherExitCode launcherExitCode = LauncherExitCode.OK;
                    if (launcherExitCode == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return launcherExitCode;
                }
                Restart.this.LOG.error((Object)("Failed to kill " + appName.getName()));
                LauncherExitCode launcherExitCode = LauncherExitCode.ERROR;
                if (launcherExitCode == null) {
                    1.$$$reportNull$$$0(2);
                }
                return launcherExitCode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/launcher/ep/commands/Restart$1", "run"));
            }
        });
        if (stopCode != LauncherExitCode.OK) {
            LauncherExitCode launcherExitCode = stopCode;
            if (launcherExitCode == null) {
                Restart.$$$reportNull$$$0(11);
            }
            return launcherExitCode;
        }
        this.LOG.info((Object)("Starting " + appName.getName() + "..."));
        Run.setConsoleCtrlCloseHandlerIfNeeded(context, this.LOG);
        UpToDateLauncherContext upToDateContext = new UpToDateLauncherContext(context);
        LauncherExitCode launcherExitCode = Start.doStart(upToDateContext, this.LOG, new FakeLauncherProcess(upToDateContext, this.LOG));
        if (launcherExitCode == null) {
            Restart.$$$reportNull$$$0(12);
        }
        return launcherExitCode;
    }

    public void printUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Restart.$$$reportNull$$$0(13);
        }
        if (context == null) {
            Restart.$$$reportNull$$$0(14);
        }
        printer.print(NAME, "restarts " + context.getAppConfig().getAppName().getName() + " in background, " + this.getComplexCommandUsageText());
    }

    @Override
    public void printStandaloneUsage(@NotNull Command.UsagePrinter printer, @NotNull LauncherContext context) {
        if (printer == null) {
            Restart.$$$reportNull$$$0(15);
        }
        if (context == null) {
            Restart.$$$reportNull$$$0(16);
        }
        String name = context.getAppConfig().getAppName().getName();
        printer.print(NAME, "restarts " + name + " in background");
        printer.print("restart soft", "restarts " + name + " in background using soft shutdown and soft start");
        if (context.getArguments().isJavaApplication()) {
            Run.printAdHocJvmOptionsInfo(false);
            ConsoleLogger.error((String)("Use \"--app\" option to restart " + name + " only and keep the launcher; in this case " + name + " start options and arguments are reused from the previous start and cannot be changed"));
            ConsoleLogger.error();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/commands/Restart";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 5: 
            case 8: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "printer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrderId";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/commands/Restart";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartCommand";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doRun";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "doRestartApp";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "doRun";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doRestartApp";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "printUsage";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "printStandaloneUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FakeLauncherProcess
    implements Start.LauncherProcess {
        @NotNull
        private final UpToDateLauncherContext myContext;
        @NotNull
        private final Logger myLog;

        public FakeLauncherProcess(@NotNull UpToDateLauncherContext context, @NotNull Logger LOG) {
            if (context == null) {
                FakeLauncherProcess.$$$reportNull$$$0(0);
            }
            if (LOG == null) {
                FakeLauncherProcess.$$$reportNull$$$0(1);
            }
            this.myContext = context;
            this.myLog = LOG;
        }

        @Override
        public void start() {
        }

        @Override
        public boolean isAlive() {
            return true;
        }

        @Override
        public int getExitCode() throws IllegalThreadStateException {
            if (Start.isAppRunning(this.myContext, this.myLog, true)) {
                throw new IllegalThreadStateException();
            }
            return LauncherExitCode.ERROR.getValue();
        }

        @Override
        public void beforeWaiting() {
        }

        @Override
        public void onTimeoutException() {
        }

        @Override
        public void afterWaiting() {
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "LOG";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/launcher/ep/commands/Restart$FakeLauncherProcess";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

