/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.run;

import com.jetbrains.launcher.AppFiles;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.run.UpToDateLauncherContext;
import com.jetbrains.launcher.util.LauncherUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AgentRuntimeHelper {
    @NotNull
    private final UpToDateLauncherContext myContext;
    @NotNull
    private final AppFiles myOldAppFiles;

    public AgentRuntimeHelper(@NotNull UpToDateLauncherContext context) {
        if (context == null) {
            AgentRuntimeHelper.$$$reportNull$$$0(0);
        }
        this.myContext = context;
        this.myOldAppFiles = context.getAppFiles();
    }

    public void beforeRun() {
        AgentRuntimeHelper.deleteRuntimeFiles(AgentRuntimeHelper.getRuntimeFiles(this.myOldAppFiles, false));
    }

    public void beforeStop() throws IOException {
        ArrayList<File> oldRuntimeFiles = new ArrayList<File>(AgentRuntimeHelper.getRuntimeFiles(this.myOldAppFiles, true));
        AppFilesEx currentAppFiles = this.myContext.getAppFiles();
        oldRuntimeFiles.removeAll(AgentRuntimeHelper.getRuntimeFiles((AppFiles)currentAppFiles, true));
        AgentRuntimeHelper.deleteRuntimeFiles(oldRuntimeFiles);
        RuntimeUtil.setExitFlag((AppFiles)currentAppFiles);
    }

    public boolean afterRun() {
        AppFilesEx currentAppFiles = this.myContext.getAppFiles();
        boolean hasExitFlag = RuntimeUtil.isExitFlagSet((AppFiles)this.myOldAppFiles) || RuntimeUtil.isExitFlagSet((AppFiles)currentAppFiles);
        LinkedHashSet<File> runtimeFiles = new LinkedHashSet<File>(AgentRuntimeHelper.getRuntimeFiles(this.myOldAppFiles, true));
        runtimeFiles.addAll(AgentRuntimeHelper.getRuntimeFiles((AppFiles)currentAppFiles, true));
        AgentRuntimeHelper.deleteRuntimeFiles(runtimeFiles);
        return hasExitFlag;
    }

    @NotNull
    private static List<File> getRuntimeFiles(@NotNull AppFiles appFiles, boolean includeStartFlag) {
        if (appFiles == null) {
            AgentRuntimeHelper.$$$reportNull$$$0(1);
        }
        List list = RuntimeUtil.getAppRuntimeFiles((AppFiles)appFiles, (boolean)includeStartFlag);
        if (list == null) {
            AgentRuntimeHelper.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static void deleteRuntimeFiles(@NotNull Collection<File> runtimeFiles) {
        if (runtimeFiles == null) {
            AgentRuntimeHelper.$$$reportNull$$$0(3);
        }
        for (File runtimeFile : runtimeFiles) {
            LauncherUtil.delete(runtimeFile, null);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appFiles";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/run/AgentRuntimeHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runtimeFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/run/AgentRuntimeHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRuntimeFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRuntimeFiles";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "deleteRuntimeFiles";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

